// token_test1.sc: test bench for c_token.sc
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 02/12/02 RD	applied naming convention, integrated with distribution
// 02/07/02 RD	initial version, one sender and receiver thread


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <sim.sh>


#define N		200	// total number of tokens fired

import "c_token";


int Rnd(int Range)		// random number in range [0...Range-1]
{
    return((unsigned int)(drand48() * (double)Range));
}


behavior TokenUser(
    i_token Token)
{
    void ProduceToken(int s)
    {
	printf("Time%4s: Token user producing %d tokens.\n",
		time2str(now()), s);
	Token.produce(s);
    }

    void ConsumeToken(int r)
    {
	printf("Time%4s: Token user consuming %d tokens.\n",
		time2str(now()), r);
	Token.consume(r);
    }

    void main(void)
    {
	int r = 0,
	    s = 0,
	    t,
	    n = 0;

	while(r < N)	// all tokens consumed?
	{
	    if (n > 0)	// can we consume?
	    {
		if (s < N)	// can we produce?
		{
		    if (Rnd(2))	// consume or produce
		    {
			if (n > 10)
			{
			    t = Rnd(10)+1;
			}
			else
			{
			    t = Rnd(n)+1;
			}
			ConsumeToken(t);
			n -= t;
			r += t;
		    }
		    else
		    {
			if (N-s > 10)
			{
			    t = Rnd(10)+1;
			}
			else
			{
			    t = Rnd(N-s)+1;
			}
			ProduceToken(t);
			n += t;
			s += t;
		    }
		}
		else	// must consume
		{
		    if (n > 10)
		    {
			t = Rnd(10)+1;
		    }
		    else
		    {
			t = Rnd(n)+1;
		    }
		    ConsumeToken(t);
		    n -= t;
		    r += t;
		}
	    }
	    else	// must produce
	    {
		if (N-s > 10)
		{
		    t = Rnd(10)+1;
		}
		else
		{
		    t = Rnd(N-s)+1;
		}
		ProduceToken(t);
		n += t;
		s += t;
	    }
	    printf("Time%4s: %d tokens available.\n",
			time2str(now()), n);
	    assert(r + n == s);
	}
	assert(r == N);
	assert(s == N);
	assert(n == 0);
    }
};


behavior Main			// test bench for token
{
    c_token    Token;
    TokenUser  u1(Token);

    int main(void)
    {
	printf("Time%4s: token_test1: Starting...\n",
		time2str(now()));
	printf("Time%4s: Running 1 thread as consumer and producer.\n",
		time2str(now()));
	u1.main();
	printf("Time%4s: token_test1: Done.\n",
		time2str(now()));
	return 0;
    }
};


// EOF token_test1.sc
