// notify4.sc

#include <sim.sh>

#include <stdio.h>
#include <assert.h>

behavior A(in event e, inout int x)
{
	void main(void)
	{
	int	i;

	for(i=0; i<100; i++)
	   { wait e;
	     x++;
	    }
	}
};

behavior B(in event e, inout int y)
{
	void main(void)
	{
	int	i;

	for(i=0; i<100; i++)
	   { wait e;
	     y++;
	    }
	}
};

behavior C(out event e)
{
	void main(void)
	{
	int	i;

	for(i=0; i<100; i++)
	   { notify e;
	     waitfor(1);
	    }
	}
};

behavior Main
{
	event	e;
	int	x = 0;
	int	y = 0;
	A	a(e, x);
	B	b(e, y);
	C	c(e);

	int main(void)
	{
	puts("notify4: Starting...");

	par {	a.main();
		b.main();
		c.main();
		};
	assert(x == 100);
	assert(y == 100);
	assert(now() == 100);

	par {	a.main();
		b.main();
		c.main();
		};
	assert(x == 200);
	assert(y == 200);
	assert(now() == 200);

	puts("notify4: Done.");
	return(0);
	}
};

// EOF
