/* DataTypes.sc: built-in datatypes in SpecC	*/
/* -------------				*/


behavior DataTypes(
	in int DummyIn,
	out int DummyOut)
{

	/*** standard C/C++ datatypes ***/

bool		   Boolean;	/*  1 bit, [false=0,true=1] */
char		   Character;	/*  8 bit, signed,   [-128,127]		      */
unsigned char	   UCharacter;	/*  8 bit, unsigned, [0,255]		      */
short		   ShortInt;	/* 16 bit, signed,   [-32768,32767]	      */
unsigned short	   UShortInt;	/* 16 bit, unsigned, [0,65535]		      */
int		   Integer;	/* 32 bit, signed,   [-2147483648,2147483647] */
unsigned int	   UInteger;	/* 32 bit, unsigned, [0,4294967295]	      */
long		   Long;	/* 32 bit, signed,   [-2147483648,2147483647] */
unsigned long	   ULong;	/* 32 bit, unsigned, [0,4294967295]	      */
long long	   LongLong;	/* 64 bit, signed,   [-9223372036854775808,
							9223372036854775807]  */
unsigned long long ULongLong;	/* 64 bit, unsigned, [0,18446744073709551615] */
float		   Float;	/* 32 bit */
double		   Double;	/* 64 bit */
long double	   LongDouble;	/* 96 bit */

typedef void Empty;

	/*** special SpecC datatypes ***/

bit[7:0]		Bits;	/* (abs(l-r)+1) bit, signed */
unsigned bit[1:8]	UBits;	/* (abs(l-r)+1) bit, unsigned */

	/*** pointers ***/

char	*String;
void	*AnyPointer;
char	*Int2Asc(int);
int	(*square)(int);		/* pointer to square() function */
void (*signal_(int, void (*)(int)))(int);	/* from signal.h */
void (*signal_(int A, void (*B)(int C)))(int D);

	/*** arrays ***/

int	X[4];		/* four integers */
int	*Y[10];		/* ten pointers to integers */
int	XY[10][20];	/* ten arrays of twenty integers */
float	(*BinOps[8])(float, float);	/* array of eight pointers to fcts. */
int	(*ArrayPtr)[10];	/* pointer to array of 10 integers */

	/*** pointer and array equivalence ***/

char *func(char *c, int x[])
{
int	a[10];

a[0]	= *a	= *c + c[2] + x[4] + *(x+4);
return "42";
}

	/*** user-defined data types ***/

typedef event	MyEvent;
struct StructDecl;
struct StructDef
{
//	struct StructDecl error_aggregate_incomplete;
//	event error_event_type_not_plain;	/* bug fix 07/13/02, RD */
//	MyEvent error_event_type_not_plain2;	/* bug fix 07/13/02, RD */
	int i;
};

void fct0(
//	struct StructDecl error_aggregate_incomplete,
//	event error_event_type_not_plain,	/* bug fix 07/13/02, RD */
//	MyEvent error_event_type_not_plain2,	/* bug fix 07/13/02, RD */
	int i
	);

	/*** example expressions with SpecC datatypes ***/

void main(void)
{
enum E { a, b, c, d };
struct S { int i; char c[10]; float f; };
const int	Size = 42 * sizeof(int);
int		IntArray[4 - 5 * -6.0 + Size + c]
		= { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 };
int		IntArray3x3[3][3]
		= { { 1,2,3 },
		    { 4,5,6 },
		    { 7,8,9 } };
int		IntArray4x3x3[4][3][3]
		={{ { 1,2,3 },
		    { 4,5,6 },
		    { 7,8,9 } },
		  { { 1,2,3 },
		    { 4,5,6 },
		    { 7,8,9 } },
		  { { 1,2,3 },
		    { 4,5,6 },
		    { 7,8,9 } },
		  { { 1,2,3 },
		    { 4,5,6 },
		    { 7,8,9 } }};
struct S s1 = { 42, {'a', 'b', 'c'}, 3.1415 },
	 s2[4] = {
		{ 42, {'a', 42, 'c'}, 42 },
		{ 0 },
		{ 42, "test", 3.1415 } };

Boolean = true;
Character = '\n';
UCharacter = '\xff';
ShortInt = -12345;
UShortInt = 12345;
Integer = -123123123;
UInteger = 123123123u;
Long = -123123123l;
ULong = 123123123uL;
LongLong = -1234560123456789lL;
ULongLong = 1234560123456789ull;
Float = 3.1415f;
Double = 1234.56789e-33;
LongDouble = 123456789.0123456789012345e+123l;

String = "Attention!!! \n\t\v \b\r\a\f \\ ' \" Attention!!!";

Bits = 00011110B;			/* assignment of bitstring-literal */
UBits = 11100011ub;

UBits = Bits[2:5] @ 01B @ Bits[0:1];	/* extraction and concatenation */
UBits = 5[7:0] + Bits * 42[7:0];	/* integer arithmetic */
UBits = ~(Bits | 10101010B);		/* logical arithmetic */
UBits[2] = Bits[1];			/* array access = bit extraction */
Bits[3:4] = (Bits & 111b)[0:7][2] & (UBits + 4)[27];
}

	/*** implicit/explicit conversions from/to bitvectors ***/

int f(int i, bit[7:0] b)
{
long	l;

l = i + b;
l += 42[3:0];

return(l * 1010b);
}

};


int y;

void g(void)
{
y = 0xffffffff;		// ok
// y = 0x1ffffffff;	// Hex. constant 0x1ffffffff out of range for 'int'!
y = 0xffffffffl;	// ok
y = 0xffffffffu;	// ok
y = 0xfffffffful;	// ok

// y = 4294967295;	// Decimal constant 4294967295 out of range for 'int'!
y = 4294967295u;	// ok
y = 2147483647;		// ok
// y = 2147483648;	// Decimal constant 2147483648 out of range for 'int'!
// y = -2147483648;	// Decimal constant 2147483648 out of range for 'int'!
y = -2147483647;	// ok
}

/* EOF */
