/************************************************************************/
/* IntRep/DelydAssgn.h: SpecC Internal Representation, DelydAssgn Class	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 09/11/03 */
/************************************************************************/

/* last update: 09/26/06 */

/* modifications: (most recent first)
 *
 * 09/26/06 PC  Adjustments for scrc 2.1
 * 06/03/05 RD	reorganized and renamed global type names
 * 06/15/04 PC  Adjustments for scrc 2.0
 * 10/23/03 RD	added origin and state infos to delayed assignment
 * 10/22/03 RD	completed functionality
 * 10/03/03 RD	inserted more functionality
 * 09/12/03 RD	filled with content
 * 09/11/03 RD	initial version
 */

/* NOTE: This file provides special support for the C++ code generator   */
/*       when generating delayed assignments from/to temporary variables */
/*       in order to implement 'after' and 'piped' statements in 'fsmd'; */
/*       these data structures are used only temporarily during code     */
/*       generation; thus, this is internal only!                        */


#ifndef INTREP_DELYDASSGN_H
#define INTREP_DELYDASSGN_H


#include "Global.h"
#include "IntRep/Expression.h"


/*** enumeration types **************************************************/


enum SIR_DelydAssgnType		/* delayed assignment types */
{				/* (see class SIR_DelydAssgn) */

SIR_DELYDASSGN_AFTER,
SIR_DELYDASSGN_PIPED
};


/*** type definitions ***************************************************/


typedef enum SIR_DelydAssgnType		SIR_DELYDASSGN;

typedef class SIR_DelydAssgn		sir_delydassgn;
typedef SIR_List<sir_delydassgn>	sir_delydassgn_list;
typedef class SIR_DlydAssgns		sir_dlydassgns;

typedef class SIR_TmpVar		sir_tmpvar;
typedef SIR_List<sir_tmpvar>		sir_tmpvar_list;
typedef class SIR_TmpVars		sir_tmpvars;

typedef class SIR_Symbol		sir_symbol;	/* cyclic link */
typedef class SIR_FsmdStmnt		sir_fsmdstmnt;	/* cyclic link */
typedef class SIR_FsmdState		sir_fsmdstate;	/* cyclic link */


/*** class declarations *************************************************/


	/**********************/
	/*** SIR_DelydAssgn ***/
	/**********************/


class SIR_DelydAssgn :			/* delayed assignment */
	public SIR_ListElem<SIR_DelydAssgn>	/* is a list element */
{
public:
SIR_DELYDASSGN	Type;		/* delayed assignment type */
sir_tmpvar	*TmpVar;	/* link to the temporary variable used */
sir_expression	*Condition;	/* condition (or NULL) */
int		Cycles;		/* cycle count */
sir_fsmdstmnt	*Origin;	/* link back to the originating statement */
const char	*OriginState;	/* link back to name of originating state */
sir_fsmdstate	*State;		/* link back to the state this is in */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_DelydAssgn(				/* constructor #1 */
	SIR_DELYDASSGN	Type,
	sir_tmpvar	*TmpVar,
	sir_expression	*Condition,
	int		Cycles,
	sir_fsmdstmnt	*Origin,
	const char	*OriginState,
	sir_fsmdstate	*State = NULL);

SIR_DelydAssgn(				/* constructor #2 (duplicator) */
	sir_delydassgn	*Original);

~SIR_DelydAssgn(void);			/* destructor */


static int Cmp(				/* compare to entries (like strcmp) */
	sir_delydassgn	*Assgn1,
	sir_delydassgn	*Assgn2);

bool CheckCollision(			/* check for unintended collision */
	bool		IssueWarning = true);	/* (and warn about it) */


ERROR WriteSC(				/* generates C++ source code */
	gl_io		*IO,
	bool		WriteNotes);
};


	/**********************/
	/*** SIR_DlydAssgns ***/
	/**********************/


class SIR_DlydAssgns :			/* sequence of delayed assignments */
	public SIR_List<SIR_DelydAssgn>	/* is simply a list of delayed assgn.*/
{					/* with additional methods */
public:


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_DlydAssgns(			/* constructor #1 */
	sir_delydassgn	*FirstEntry = NULL);

~SIR_DlydAssgns(void);		/* destructor */


sir_delydassgn	*Find(		/* find an assignment in the list */
	sir_delydassgn	*Assignment);	/* returns NULL if not found */

sir_delydassgn *Insert(		/* insert (copy of) assignment into the list */
	sir_delydassgn	*Assignment);	/* (returns NULL if already exists) */


ERROR WriteSC(			/* generates C++ source code */
	gl_io		*IO,
	bool		WriteNotes);
};


	/******************/
	/*** SIR_TmpVar ***/
	/******************/


class SIR_TmpVar :			/* tmp. variable for delayed assign. */
	public SIR_ListElem<SIR_TmpVar>	/* is a list element */
{
public:
sir_symbol	*Symbol;	/* link to temp. variable symbol */
sir_expression	*Target;	/* link to final target */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_TmpVar(				/* constructor #1 */
	sir_symbol	*Symbol,
	sir_expression	*Target);

~SIR_TmpVar(void);			/* destructor */
};


	/*******************/
	/*** SIR_TmpVars ***/
	/*******************/


class SIR_TmpVars :			/* list of temp. variables */
	public SIR_List<SIR_TmpVar>	/* is simply a list of tmp. vars. */
{					/* with additional methods */
public:
sir_symbols	*Scope;		/* scope for temp. variables */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_TmpVars(			/* constructor #1 */
	sir_symbols	*Scope,
	sir_tmpvar	*FirstEntry = NULL);

~SIR_TmpVars(void);		/* destructor */


sir_tmpvar *Find(		/* find an entry by target expression */
	sir_expression	*Target);

sir_tmpvar *FindOrInsert(	/* find old or insert new temp. var. */
	sir_expression	*Target,	/* for this target expression */
	int		Size);
};


/*** exported functions *************************************************/


	/* none */


#endif /* INTREP_DELYDASSGN_H */

/* EOF IntRep/DelydAssgn.h */
