// OnesCounter_4b_old.sc: OnesCounter, Accellera style 4b (SpecC 1.0)
//
// (last update: 02/22/02, RD)
//
// Model characteristics:
// - Accellera style:	4b (4, plus accurate port model by use of instances)
// - SpecC language:	1.0
// - Machine type:	Moore (state-based)
// - Reset type:	synchronous
// - Output ports:	unbuffered


import "alu";
import "shift";


behavior OnesCounter(
	in  event		CLK,		// system clock
	in  bool		RST,		// system reset
	in  unsigned bit[31:0]	Inport,
	in  unsigned bit[1]	Start,
	out unsigned bit[31:0]	Outport,
	out unsigned bit[1]	Done)
{

   bit[31:0]	alu0_a, alu0_b, alu0_r;
   bit[ 3:0]	alu0_ctrl;
   alu		ALU0(alu0_a, alu0_b, alu0_ctrl, alu0_r);

   bit[31:0]	shift0_a, shift0_b, shift0_r;
   bit[1]	shift0_ctrl;
   shift	SHIFT0(shift0_a, shift0_b, shift0_ctrl, shift0_r);

   void main(void)
   {
     unsigned bit[31:0]	RF0[4];		// storage (must not read after write!)
     unsigned bit[31:0]	BUS0,		// internal busses
			BUS1,
			BUS2;

     enum StateType
	{ S0, S1, S2, S3,
	  S4, S5, S6, S7
	 };
     enum StateType	State;			// state variable

     State = S0;
     while(true)
	{ wait(CLK);

	  Outport = 0;				// default assignments
	  Done = 0;

	  if (RST)
	     { State = S0;			// reset actions
	      }
	  else
	     { switch(State)			// state actions
		  {
		    case S0 : {	if (Start)
				     State = S1;
				else
				     State = S0;
				break;
			       }
		    case S1 : {	BUS2 = Inport;
				RF0[0] = BUS2;
				State = S2;
				break;
			       }
		    case S2 : { BUS2 = 0;
				RF0[1] = BUS2;
				State = S3;
				break;
			       }
		    case S3 : { BUS2 = 1;
				RF0[3] = BUS2;
				State = S4;
				break;
			       }
		    case S4 : { BUS0 = RF0[0];
				BUS1 = RF0[3];
				alu0_a = BUS0; alu0_b = BUS1; alu0_ctrl = 0x8;
				ALU0.main();
				BUS2 = alu0_r;
				RF0[2] = BUS2;
				State = S5;
				break;
			       }
		    case S5 : { BUS0 = RF0[1];
				BUS1 = RF0[2];
				alu0_a = BUS0; alu0_b = BUS1; alu0_ctrl = 0x0;
				ALU0.main();
				BUS2 = alu0_r;
				RF0[1] = BUS2;
				State = S6;
				break;
			       }
		    case S6 : { BUS0 = RF0[0];
				shift0_a = BUS0; shift0_b = 1; shift0_ctrl = 0;
				SHIFT0.main();
				BUS2 = shift0_r;
				RF0[0] = BUS2;
				if (BUS2 == 0)
				     State = S7;
				else
				     State = S4;
				break;
			       }
		    case S7 : { BUS1 = RF0[1];
				Outport = BUS1;
				Done = 1;
				if (Start)
				     State = S7;
				else
				     State = S0;
				break;
			       }
		   }
	      }
	 }
    }
};


// test bench /////////////////////////////////////////////////////////////


#include <stdio.h>
#include <stdlib.h>
#include "../../inc/sim.sh"	// #include <sim.sh>


const sim_time ClockPeriod  = 10;
const unsigned int NumTests = 20;


unsigned int Rnd(unsigned int Range)	// random number in range [0...Range-1]
{
    return((unsigned int)(drand48() * (double)Range));
}


unsigned int Ones(unsigned int Value)
{
    unsigned int n;

    n = 0;
    while(Value)
    {
	n += Value & 1u;
	Value >>= 1;
    }
    return(n);
}


behavior ClockGen(
	out event         CLK)
{
    void main(void)
    {
	while(true)
	{
	    waitfor(ClockPeriod);
//	    printf("Time%6s: Clock tick!\n",
//			time2str(now()));
	    notify CLK;
	}
    }
};


behavior TestBench(
	in  event		CLK,
	out bool		RST,
	out unsigned bit[31:0]	Inport,
	out unsigned bit[1]	Start,
	in  unsigned bit[31:0]	Outport,
	in  unsigned bit[1]	Done)
{
    void main(void)
    {
	unsigned int	Test,
			Value;

	printf("Time%6s: Starting...\n",
		time2str(now()));
	wait(CLK);

	printf("Time%6s: Resetting the unit...\n",
		time2str(now()));
	RST = 1;
	wait(CLK);

	Inport = 0;
	Start = 0;
	wait(CLK);

	RST = 0;
	wait(CLK);

	for(Test=1; Test<=NumTests; Test++)
	{
	    Value = Rnd(0xffff);
	    printf("Time%6s: Running test %u with value 0x%04x.\n",
			time2str(now()), Test, Value);
	    Inport = Value;
	    Start = 1;
	    while(!Done)
	    {
		wait(CLK);
	    }

	    printf("Time%6s: Computed result is %u. ",
			time2str(now()), (unsigned int)Outport);
	    if (Outport == Ones(Value))
	    {
		printf("Correct!\n");
	    }
	    else
	    {
		printf("FALSE! Should be %u!\n", Ones(Value));
		exit(10);
	    }
	    Start = 0;
	    while(Done)
	    {
		wait(CLK);
	    }
	}
	printf("Time%6s: Done.\n",
		time2str(now()));
	exit(0); // stop the simulation
    }
};


behavior Main
{
    event            CLK;
    bool             RST;
    unsigned bit[32] Data1,
                     Data2;
    unsigned bit[1]  Flag1,
                     Flag2;
    ClockGen         cg0(CLK);
    OnesCounter      oc0(CLK, RST, Data1, Flag1, Data2, Flag2);
    TestBench        tb0(CLK, RST, Data1, Flag1, Data2, Flag2);

    int main(void)
    {
	par
	{
	    cg0.main();
	    oc0.main();
	    tb0.main();
	}
	return(0);
    }
};


// EOF
