// Buffered.sc (based on Signal.sc)
//
// purpose: testing the initialization of ordinary and 'buffered' variables
//          (plus other features)
//
// 12/19/02 RD	created from Signal.sc
// 01/10/03 RD	extended to cover 'buffered' variables with internal clocking


#include <string.h>
#include <assert.h>


signal bit[1] clk, rst;


/*** 'buffered' variables in global scope ***/

int                   g0 = 5;
buffered[clk;rst] int g1 = 5;
int                   G0[10] = { 0,1,2,3,4,5,6,7,8,9 };
buffered[clk;rst] int G1[10] = { 0,1,2,3,4,5,6,7,8,9 };
int                   G027[2][7] = { { 0, 1, 2, 3, 4, 5, 6},
				     {10,11,12,13,14,15,16} };
buffered[clk;rst] int G227[2][7] = { { 0, 1, 2, 3, 4, 5, 6},
				     {10,11,12,13,14,15,16} };
int        G0234[2][3][4] =
	{ { {   0,  1,  2,  3 },
	    {  10, 11, 12, 13 },
	    {  20, 21, 22, 23 } },
	  { { 100,101,102,103 },
	    { 110,111,112,113 },
	    { 120,121,122,123 } } };
buffered[clk;rst] int G1234[2][3][4] =
	{ { {   0,  1,  2,  3 },
	    {  10, 11, 12, 13 },
	    {  20, 21, 22, 23 } },
	  { { 100,101,102,103 },
	    { 110,111,112,113 },
	    { 120,121,122,123 } } };

char                   *gp1   = "abc";
char                   gs1[4] = {'a', 'b', 'c'};
char                   gs2[4] = "abc";
buffered[clk;rst] char *gpp1   = "abc";
buffered[clk;rst] char gps1[4] = {'a', 'b', 'c'};
buffered[clk;rst] char gps2[4] = "abc";

buffered[10] int GlobBufClk10 = 42;
buffered[5; rst] int GlobBufClk5[3] = { 1,2,3 };


behavior Main
{
	/*** 'buffered' variables in class scope ***/

	int                   i0 = 5;
	buffered[clk;rst] int i1 = 5;
	int                   I [10] = { 0,1,2,3,4,5,6,7,8,9 };
	buffered[clk;rst] int I1[10] = { 0,1,2,3,4,5,6,7,8,9 };
	buffered[clk;rst] int I2[10][10];
	buffered[clk;rst] int I3[10][10][10];

	char                   *p1   = "abc";
	char                   s1[4] = {'a', 'b', 'c'};
	char                   s2[4] = "abc";
	buffered[clk;rst] char *pp1   = "abc";
	buffered[clk;rst] char ps1[4] = {'a', 'b', 'c'};
	buffered[clk;rst] char ps2[4] = "abc";

//	no unspecified array size allowed for 'buffered'!

	buffered[(5+5)] int ClsBufClk10 = 42;
	buffered[5; rst] int ClsBufClk5[3] = { 1,2,3 };

	int main(void)
	{
		/*** 'buffered' variables in local scope ***/

		int                   l0 = 5;
		buffered[clk;rst] int l1 = 5;
		int                   L0[10] = { 0,1,2,3,4,5,6,7,8,9 };
		buffered[clk;rst] int L1[10] = { 0,1,2,3,4,5,6,7,8,9 };
		int                   L027[2][7] = { { 0, 1, 2, 3, 4, 5, 6},
						     {10,11,12,13,14,15,16} };
		buffered[clk;rst] int L227[2][7] = { { 0, 1, 2, 3, 4, 5, 6},
						     {10,11,12,13,14,15,16} };
		int        L0234[2][3][4] =
		{ { {   0,  1,  2,  3 },
		    {  10, 11, 12, 13 },
		    {  20, 21, 22, 23 } },
		  { { 100,101,102,103 },
		    { 110,111,112,113 },
		    { 120,121,122,123 } } };
		buffered[clk;rst] int L1234[2][3][4] =
		{ { {   0,  1,  2,  3 },
		    {  10, 11, 12, 13 },
		    {  20, 21, 22, 23 } },
		  { { 100,101,102,103 },
		    { 110,111,112,113 },
		    { 120,121,122,123 } } };

		char                   *lp1   = "abc";
		char                   ls1[4] = {'a', 'b', 'c'};
		char                   ls2[4] = "abc";
		buffered[clk;rst] char *lpp1   = "abc";
		buffered[clk;rst] char lps1[4] = {'a', 'b', 'c'};
		buffered[clk;rst] char lps2[4] = "abc";

		buffered[(15-5)] int LocBufClk10 = 42;
		buffered[(2*2.5); rst] int LocBufClk5[3] = { 1,2,3 };


		// initialization tests

		assert(i0 == 5);
		assert(i1 == 5);

		assert(I[0] == 0);
		assert(I[1] == 1);
		assert(I[9] == 9);

		assert(I1[0] == 0);
		assert(I1[1] == 1);
		assert(I1[9] == 9);

		assert(l0 == 5);
		assert(l1 == 5);

		assert(L0[0] == 0);
		assert(L0[1] == 1);
		assert(L0[9] == 9);

		assert(L1[0] == 0);
		assert(L1[1] == 1);
		assert(L1[9] == 9);

		assert(L027[0][0] ==  0);
		assert(L027[0][1] ==  1);
		assert(L027[0][2] ==  2);
		assert(L027[1][0] == 10);
		assert(L027[1][1] == 11);
		assert(L027[1][6] == 16);

		assert(L227[0][0] ==  0);
		assert(L227[0][1] ==  1);
		assert(L227[0][2] ==  2);
		assert(L227[1][0] == 10);
		assert(L227[1][1] == 11);
		assert(L227[1][6] == 16);

		assert(L0234[0][0][0] ==   0);
		assert(L0234[1][0][0] == 100);
		assert(L0234[0][1][0] ==  10);
		assert(L0234[0][0][1] ==   1);
		assert(L0234[1][2][3] == 123);

		assert(L1234[0][0][0] ==   0);
		assert(L1234[1][0][0] == 100);
		assert(L1234[0][1][0] ==  10);
		assert(L1234[0][0][1] ==   1);
		assert(L1234[1][2][3] == 123);

		assert(g0 == 5);
		assert(g1 == 5);

		assert(G0[0] == 0);
		assert(G0[1] == 1);
		assert(G0[9] == 9);

		assert(G1[0] == 0);
		assert(G1[1] == 1);
		assert(G1[9] == 9);

		assert(G027[0][0] ==  0);
		assert(G027[0][1] ==  1);
		assert(G027[0][2] ==  2);
		assert(G027[1][0] == 10);
		assert(G027[1][1] == 11);
		assert(G027[1][6] == 16);

		assert(G227[0][0] ==  0);
		assert(G227[0][1] ==  1);
		assert(G227[0][2] ==  2);
		assert(G227[1][0] == 10);
		assert(G227[1][1] == 11);
		assert(G227[1][6] == 16);

		assert(G0234[0][0][0] ==   0);
		assert(G0234[1][0][0] == 100);
		assert(G0234[0][1][0] ==  10);
		assert(G0234[0][0][1] ==   1);
		assert(G0234[1][2][3] == 123);

		assert(G1234[0][0][0] ==   0);
		assert(G1234[1][0][0] == 100);
		assert(G1234[0][1][0] ==  10);
		assert(G1234[0][0][1] ==   1);
		assert(G1234[1][2][3] == 123);

		assert(0 == strcmp(p1, "abc"));
		assert(0 == strcmp(s1, "abc"));
		assert(0 == strcmp(s2, "abc"));
		assert(0 == strcmp(pp1, "abc"));
		assert(0 == strcmp(ps1, "abc"));
		assert(0 == strcmp(ps2, "abc"));

		assert(0 == strcmp(lp1, "abc"));
		assert(0 == strcmp(ls1, "abc"));
		assert(0 == strcmp(ls2, "abc"));
		assert(0 == strcmp(lpp1, "abc"));
		assert(0 == strcmp(lps1, "abc"));
		assert(0 == strcmp(lps2, "abc"));

		assert(0 == strcmp(gp1, "abc"));
		assert(0 == strcmp(gs1, "abc"));
		assert(0 == strcmp(gs2, "abc"));
		assert(0 == strcmp(gpp1, "abc"));
		assert(0 == strcmp(gps1, "abc"));
		assert(0 == strcmp(gps2, "abc"));

		assert(GlobBufClk10 == 42);
		assert(ClsBufClk10 == 42);
		assert(LocBufClk10 == 42);
		assert(GlobBufClk5[1] == 2);
		assert(ClsBufClk5[1] == 2);
		assert(LocBufClk5[1] == 2);


		// dynamic tests

		L0[1] = -1;
		L1[1] = -1;
		assert(L0[0] == 0);
		assert(L0[1] == -1);
		assert(L0[9] == 9);
		assert(L1[0] == 0);
		assert(L1[1] == 1);
		assert(L1[9] == 9);
		notify clk; wait clk;	/* update the buffers once */
		assert(L0[0] == 0);
		assert(L0[1] == -1);
		assert(L0[9] == 9);
		assert(L1[0] == 0);
		assert(L1[1] == -1);
		assert(L1[9] == 9);

		L1[4] = L1[7];
		L1[7] = L1[4];
		assert(L1[0] == 0);
		assert(L1[1] == -1);
		assert(L1[4] == 4);
		assert(L1[7] == 7);
		assert(L1[9] == 9);
		notify clk; wait clk;	/* update the buffers once */
		assert(L1[0] == 0);
		assert(L1[1] == -1);
		assert(L1[4] == 7);
		assert(L1[7] == 4);
		assert(L1[9] == 9);

		L227[0][1] = -1;
		L227[1][6] = -16;
		assert(L227[0][0] ==  0);
		assert(L227[0][1] ==  1);
		assert(L227[0][2] ==  2);
		assert(L227[1][0] == 10);
		assert(L227[1][1] == 11);
		assert(L227[1][6] == 16);
		notify clk; wait clk;	/* update the buffers once */
		assert(L227[0][0] ==  0);
		assert(L227[0][1] ==  -1);
		assert(L227[0][2] ==  2);
		assert(L227[1][0] == 10);
		assert(L227[1][1] == 11);
		assert(L227[1][6] == -16);

		L227[0][2] += L227[1][0];
		L227[1][1]++;
		assert(L227[0][0] ==  0);
		assert(L227[0][1] ==  -1);
		assert(L227[0][2] ==  2);
		assert(L227[1][0] == 10);
		assert(L227[1][1] == 11);
		assert(L227[1][6] == -16);
		notify clk; wait clk;	/* update the buffers once */
		assert(L227[0][0] ==  0);
		assert(L227[0][1] ==  -1);
		assert(L227[0][2] == 12);
		assert(L227[1][0] == 10);
		assert(L227[1][1] == 12);
		assert(L227[1][6] == -16);

		L1234[1][0][0] = 1;
		L1234[0][1][0]++;
		L1234[0][0][1] += L1234[1][0][0] + L1234[0][1][0];
		assert(L1234[0][0][0] ==   0);
		assert(L1234[1][0][0] == 100);
		assert(L1234[0][1][0] ==  10);
		assert(L1234[0][0][1] ==   1);
		assert(L1234[1][2][3] == 123);
		notify clk; wait clk;	/* update the buffers once */
		assert(L1234[0][0][0] ==   0);
		assert(L1234[1][0][0] ==   1);
		assert(L1234[0][1][0] ==  11);
		assert(L1234[0][0][1] == 111);
		assert(L1234[1][2][3] == 123);


		// internal clock tests

		GlobBufClk10 = 17;
		ClsBufClk10 = 18;
		LocBufClk10 = 19;
		GlobBufClk5[1] = -1;
		ClsBufClk5[1] = -2;
		LocBufClk5[1] = -3;
		assert(GlobBufClk10 == 42);
		assert(ClsBufClk10 == 42);
		assert(LocBufClk10 == 42);
		assert(GlobBufClk5[1] == 2);
		assert(ClsBufClk5[1] == 2);
		assert(LocBufClk5[1] == 2);
		waitfor 5;
		assert(GlobBufClk10 == 42);
		assert(ClsBufClk10 == 42);
		assert(LocBufClk10 == 42);
		assert(GlobBufClk5[1] == 2);
		assert(ClsBufClk5[1] == 2);
		assert(LocBufClk5[1] == 2);
		notify clk; wait clk;	/* wait for one sync cycle */
		assert(GlobBufClk10 == 42);
		assert(ClsBufClk10 == 42);
		assert(LocBufClk10 == 42);
		assert(GlobBufClk5[1] == -1);
		assert(ClsBufClk5[1] == -2);
		assert(LocBufClk5[1] == -3);
		waitfor 5;
		assert(GlobBufClk10 == 42);
		assert(ClsBufClk10 == 42);
		assert(LocBufClk10 == 42);
		assert(GlobBufClk5[1] == -1);
		assert(ClsBufClk5[1] == -2);
		assert(LocBufClk5[1] == -3);
		notify clk; wait clk;	/* wait for one sync cycle */
		assert(GlobBufClk10 == 17);
		assert(ClsBufClk10 == 18);
		assert(LocBufClk10 == 19);
		assert(GlobBufClk5[1] == -1);
		assert(ClsBufClk5[1] == -2);
		assert(LocBufClk5[1] == -3);


		// reset tests

		rst = 1b; wait rst;	/* reset! */

		assert(i1 == 5);
		assert(I1[0] == 0);
		assert(I1[1] == 1);
		assert(I1[9] == 9);

		assert(l1 == 5);
		assert(L1[0] == 0);
		assert(L1[1] == 1);
		assert(L1[9] == 9);

		assert(L227[0][0] ==  0);
		assert(L227[0][1] ==  1);
		assert(L227[0][2] ==  2);
		assert(L227[1][0] == 10);
		assert(L227[1][1] == 11);
		assert(L227[1][6] == 16);

		assert(L1234[0][0][0] ==   0);
		assert(L1234[1][0][0] == 100);
		assert(L1234[0][1][0] ==  10);
		assert(L1234[0][0][1] ==   1);
		assert(L1234[1][2][3] == 123);

		assert(g1 == 5);
		assert(G1[0] == 0);
		assert(G1[1] == 1);
		assert(G1[9] == 9);

		assert(G227[0][0] ==  0);
		assert(G227[0][1] ==  1);
		assert(G227[0][2] ==  2);
		assert(G227[1][0] == 10);
		assert(G227[1][1] == 11);
		assert(G227[1][6] == 16);

		assert(G1234[0][0][0] ==   0);
		assert(G1234[1][0][0] == 100);
		assert(G1234[0][1][0] ==  10);
		assert(G1234[0][0][1] ==   1);
		assert(G1234[1][2][3] == 123);

		assert(0 == strcmp(pp1, "abc"));
		assert(0 == strcmp(ps1, "abc"));
		assert(0 == strcmp(ps2, "abc"));

		assert(0 == strcmp(lpp1, "abc"));
		assert(0 == strcmp(lps1, "abc"));
		assert(0 == strcmp(lps2, "abc"));

		assert(0 == strcmp(gpp1, "abc"));
		assert(0 == strcmp(gps1, "abc"));
		assert(0 == strcmp(gps2, "abc"));

		assert(GlobBufClk10 == 17);
		assert(ClsBufClk10 == 18);
		assert(LocBufClk10 == 19);
		assert(GlobBufClk5[1] == 2);
		assert(ClsBufClk5[1] == 2);
		assert(LocBufClk5[1] == 2);

		return(0);
	}
};

// eof
