/************************************************************************/
/* IntRep/Import.h: SpecC Internal Representation, Imported File Class	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 02/10/98 */
/************************************************************************/

/* last update: 09/26/06 */

/* modifications: (most recent first)
 *
 * 09/26/06 PC  Adjustments for scrc 2.1
 * 06/03/05 RD	reorganized and renamed global type names
 * 05/31/01 RD	eliminated level 2 of SIR API
 * 05/25/01 RD	eliminated support for binary SIR files (import/export)
 * 05/25/01 RD	introduced this header (last change was 12/16/98)
 */

#ifndef INTREP_IMPORT_H
#define INTREP_IMPORT_H


#include "Global.h"
#include "IntRep/List.h"


/*** enumeration types **************************************************/


	/* none */


/*** type definitions ***************************************************/


typedef class SIR_Import		sir_import;
typedef class SIR_ImportList		sir_import_list;

typedef class SIR_Design		sir_design;	/* cyclic link */


/*** class declarations *************************************************/


	/******************/
	/*** SIR_Import ***/
	/******************/


class SIR_Import :		/* import file */
	public SIR_ListElem<SIR_Import>	/* is a list element */
{
public:
gl_string	ImportName;	/* design name */

sir_import	*Alias;		/* alias pointer (temporary only) */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Import(			/* constructor #1 */
	const char	*ImportName);

SIR_Import(			/* constructor #3 (duplicator) */
	sir_import	*Original);

~SIR_Import(void);		/* destructor */


void TakeOverAndRemove(		/* takes over these imports into the design */
	sir_design	*Design);	/* and removes this import entry */
};


	/**********************/
	/*** SIR_ImportList ***/
	/**********************/


class SIR_ImportList :		/* list of imported files */
	public SIR_List<SIR_Import>	/* is a basically a list */
{					/* with additional functions */
public:

//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_ImportList(			/* constructor #1 */
	sir_import	*NewFirstEntry = NULL);

SIR_ImportList(			/* constructor #2 (duplicator) */
	sir_import_list	*Original);

~SIR_ImportList(void);		/* destructor */


ERROR Integrate(			/* merges with imported import list */
	sir_import_list	*ImportedList);

void GarbageCollection(			/* garbage collector */
	sir_design	*Design);


sir_import *FindOrInsert(		/* find an entry or insert it */
	const char	*ImportName);	/* if it not exists           */

sir_import *Insert(			/* insert a new entry */
	const char	*ImportName);

sir_import *Find(			/* find an entry */
	const char	*ImportName);
};


#endif /* INTREP_IMPORT_H */

/* EOF IntRep/Import.h */
