/************************************************************************/
/* IntRep/Exception.h: SpecC Internal Representation, Exception Class	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 10/20/97 */
/************************************************************************/

/* last update: 06/15/04 */

/* modifications: (most recent first)
 *
 * 06/15/04 PC  Adjustments for scrc 2.0
 * 10/28/03 RD	adjusted for new member ParentStmnt in SIR_Statement
 * 11/22/02 RD	switched event list from SIR_SymbolPtrs to SIR_Events
 * 05/31/01 RD	eliminated level 2 of SIR API
 * 05/25/01 RD	eliminated support for binary SIR files (import/export)
 * 05/25/01 RD	introduced this header (last change was 04/13/99)
 */


#ifndef INTREP_EXCEPTION_H
#define INTREP_EXCEPTION_H


#include "Global.h"
#include "IntRep/Node.h"
#include "IntRep/Event.h"


/*** enumeration types **************************************************/


enum SIR_ExceptionType		/* exception types */
{				/* (see class SIR_Exception) */
SIR_EXCEPTION_TRAP,
SIR_EXCEPTION_INTERRUPT
};


/*** type definitions ***************************************************/


typedef enum SIR_ExceptionType		SIR_EXCEPT_TYPE;

typedef class SIR_Exception		sir_exception;
typedef SIR_List<sir_exception>		sir_exception_list;
typedef class SIR_Exceptions		sir_exceptions;

typedef class SIR_Statement		sir_statement;	/* cyclic link */
typedef void *				sir_stmnt_marg;	/* cyclic link */
typedef ERROR (SIR_Statement::*sir_stmnt_mptr)(void*);	/* cyclic link */

typedef class SIR_Symbol		sir_symbol;	/* cyclic link */
typedef class SIR_Symbols		sir_symbols;	/* cyclic link */
typedef void *				sir_symbol_marg;/* cyclic link */
typedef ERROR (SIR_Symbol::*sir_symbol_mptr)(void*);	/* cyclic link */

typedef class SIR_UserType		sir_usertype;	/* cyclic link */
typedef void *				sir_usertp_marg;/* cyclic link */
typedef ERROR (SIR_UserType::*sir_usertp_mptr)(void*);	/* cyclic link*/

typedef class SIR_Note			sir_note;	/* cyclic link */
typedef void *				sir_note_marg;	/* cyclic link */
typedef ERROR (SIR_Note::*sir_note_mptr)(void*);	/* cyclic link */

typedef class SIR_Expression		sir_expression;	/* cyclic link */
typedef void *				sir_expr_marg;	/* cyclic link */
typedef ERROR (SIR_Expression::*sir_expr_mptr)(void*);	/* cyclic link */


/*** class declarations *************************************************/


	/*********************/
	/*** SIR_Exception ***/
	/*********************/


class SIR_Exception :		/* exception */
	public SIR_Node,			/* is a node */
	public SIR_ListElem<SIR_Exception>	/* and a list element */
{
public:
SIR_EXCEPT_TYPE	ExceptionType;	/* type of the exception */
sir_events	*Events;	/* events */
sir_statement	*Handler;	/* handler to go to */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Exception(			/* constructor #1 */
	SIR_EXCEPT_TYPE	ExceptionType,
	sir_events	*Events,
	sir_statement	*Handler,
	unsigned int	Line = 0,
	sir_fileinfo	*FileInfo = NULL);

SIR_Exception(			/* constructor #3 (duplicator) */
	sir_exception	*Original,
	sir_statement	*ParentStmnt = NULL);

~SIR_Exception(void);		/* destructor */


sir_exceptions *GetList(void);	/* determines the list of this exception */
				/* (returns NULL if not in a list) */


ERROR DFS_ForAllNodes(		/* iterator over all nodes (depth first) */
	sir_node_mptr	MemberFct,
	sir_node_marg	MemberFctArg);

ERROR DFS_ForAllSymbols(	/* iterator over all symbols (depth first) */
	sir_symbol_mptr	MemberFct,
	sir_symbol_marg	MemberFctArg);

ERROR DFS_ForAllUserTypes(	/* iterator over all usertypes (depth first) */
	sir_usertp_mptr	MemberFct,
	sir_usertp_marg	MemberFctArg);

ERROR DFS_ForAllNotes(		/* iterator over all notes (depth first) */
	sir_note_mptr	MemberFct,
	sir_note_marg	MemberFctArg);

ERROR DFS_ForAllStatements(	/* iterator over all statements (depth first) */
	sir_stmnt_mptr	MemberFct,
	sir_stmnt_marg	MemberFctArg);

ERROR DFS_ForAllExpressions(	/* iterator over all expressions (dfs) */
	sir_expr_mptr	MemberFct,
	sir_expr_marg	MemberFctArg);


void SetAlias(			/* sets all type, usertype, symbol alias' */
	sir_exception	*Alias);/* (iterates over symbols and usertypes) */

void UnAlias(			/* unalias all type, usertype, symbol links */
	sir_symbols	*GlobalSymbols);
};


	/**********************/
	/*** SIR_Exceptions ***/
	/**********************/


class SIR_Exceptions :		/* exceptions list */
	public SIR_List<SIR_Exception>	/* is simply a list of exceptions */
{					/* with additional member(function)s */
public:

//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Exceptions(			/* constructor #1 */
	sir_exception	*FirstEntry = NULL);

SIR_Exceptions(			/* constructor #2 (duplicator) */
	sir_exceptions	*Original,
	sir_statement	*ParentStmnt = NULL);

~SIR_Exceptions(void);		/* destructor */


ERROR DFS_ForAllNodes(		/* iterator over all nodes (depth first) */
	sir_node_mptr	MemberFct,
	sir_node_marg	MemberFctArg);

ERROR DFS_ForAllSymbols(	/* iterator over all symbols (depth first) */
	sir_symbol_mptr	MemberFct,
	sir_symbol_marg	MemberFctArg);

ERROR DFS_ForAllUserTypes(	/* iterator over all usertypes (depth first) */
	sir_usertp_mptr	MemberFct,
	sir_usertp_marg	MemberFctArg);

ERROR DFS_ForAllNotes(		/* iterator over all notes (depth first) */
	sir_note_mptr	MemberFct,
	sir_note_marg	MemberFctArg);

ERROR DFS_ForAllStatements(	/* iterator over all statements (depth first) */
	sir_stmnt_mptr	MemberFct,
	sir_stmnt_marg	MemberFctArg);

ERROR DFS_ForAllExpressions(	/* iterator over all expressions (dfs) */
	sir_expr_mptr	MemberFct,
	sir_expr_marg	MemberFctArg);


void UnAlias(			/* unalias all type, usertype, symbol links */
	sir_symbols	*GlobalSymbols);

void SetAlias(			/* sets all type, usertype, symbol alias' */
	sir_exceptions	*Alias);/* (iterates over symbols and usertypes) */
};


/*** exported functions *************************************************/


	/* none */


#endif /* INTREP_EXCEPTION_H */

/* EOF IntRep/Exception.h */
