// c_mutex.sc: provides mutually exclusive access to a shared resource
// (mutex is a binary semaphore)
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 10/04/02 RD	added rule about safety of exceptions
// 02/12/02 RD	applied naming convention, integrated with distribution
// 01/23/02 RD	added method 'attempt'
// 01/23/02 RD	renamed methods to 'acquire' and 'release'
// 01/22/02 RD	bug fix: only call 'notifyone' if any threads are waiting
// 01/22/02 RD	brush up, moved into separate file "mutex.sc"
// 12/27/01 RD	initial version
//
// interface rules:
//
// - see file i_semaphore.sc
//
// channel rules:
//
// - one channel instance is required for each mutex
// - up to N threads may use the same channel instance, N=2**32-1
// - no guarantees are given for fairness of access
// - calling acquire() may suspend the calling thread indefinitely
// - this channel is only safe with respect to exceptions, if any exceptions
//   are guaranteed to occur only for all communicating threads simultaneously;
//   the behavior is undefined, if any exceptions occur only for a subset
//   of the communicating threads
// - no restrictions exist for use of 'waitfor'
// - no restrictions exist for use of 'wait', 'notify', 'notifyone'


import "i_semaphore";


channel c_mutex implements i_semaphore
{
    event         e;
    unsigned long n = 0;

    void acquire(void)
    {
	if (n++)
	{
	    wait e;
	}
    }

    void release(void)
    {
	if (--n)
	{
	    notifyone e;
	}
    }

    bool attempt(void)
    {
	if (n)
	{
	    return(false);
	}
	else
	{
	    n++;
	    return(true);
	}
    }
};


// EOF c_mutex.sc
