// Adder/ADD08_1.sc


import "GatesLib";


behavior HA(			// half-adder
	in bit[0:0]	a,
	in bit[0:0]	b,
	out bit[0:0]	s,
	out bit[0:0]	c)
{
	XOR2		xor1(a, b, s);
	AND2		and1(a, b, c);

	void main(void)
	{
	xor1.main();
	and1.main();
	}
};

behavior FA(			// full-adder
	in bit[0:0]	a,
	in bit[0:0]	b,
	in bit[0:0]	c,
	out bit[1:0]	s)
{
	bit[0:0]	x, y, z;
	HA		ha1(a, b, y, x),
			ha2(y, c, s[0], z);
	OR2		or1(x, z, s[1]);

	void main(void)
	{
	ha1.main();
	ha2.main();
	or1.main();
	}
};

behavior ADD08_1(		// 8-bit adder, structural model
	in bit[0:0]	c_in,
	in bit[7:0]	a,
	in bit[7:0]	b,
	out bit[7:0]	s,
	out bit[0:0]	c_out)
{
	bit[1:7]	c = 0;

	FA	fa0(a[0], b[0], c_in, c[1] @ s[0]),
		fa1(a[1], b[1], c[1], c[2] @ s[1]),
		fa2(a[2], b[2], c[2], c[3] @ s[2]),
		fa3(a[3], b[3], c[3], c[4] @ s[3]),
		fa4(a[4], b[4], c[4], c[5] @ s[4]),
		fa5(a[5], b[5], c[5], c[6] @ s[5]),
		fa6(a[6], b[6], c[6], c[7] @ s[6]),
		fa7(a[7], b[7], c[7], c_out @ s[7]);

	void main(void)
	{
	fa0.main();
	fa1.main();
	fa2.main();
	fa3.main();
	fa4.main();
	fa5.main();
	fa6.main();
	fa7.main();
	}
};

// EOF
