// wait6.sc

#include <sim.sh>

#include <stdio.h>
#include <assert.h>

behavior A(out event e1, out event e2, out event e3)
{
	void main(void)
	{
	waitfor 1;
	notify e1;

	waitfor 1;
	notify e2;

	waitfor 1;
	notify e1;

	waitfor 1;
	notify e1, e2;

	waitfor 1;
	notify e3;

	waitfor 1;
	notify e1, e1;

	waitfor 1;
	notify e2;

	waitfor 1;
	notify e1;

	waitfor 1;
	notify e1, e1;

	waitfor 1;
	notify e3, e3;

	waitfor 1;
	notify e3;

	waitfor 1;
	notify e2, e1;
	}
};

behavior B(in event e1, in event e2, in event e3)
{
	void main(void)
	{
	wait e1;
	assert(now() == 1);
	wait e1 && e2;
	assert(now() == 3);
	wait e1 && e2 && e3;
	assert(now() == 5);
	wait e1 && e1;
	assert(now() == 6);
	wait e1 && e1;
	assert(now() == 8);
	wait e1 && e3;
	assert(now() == 10);
	wait e1 && e2 && e3 && e3;
	assert(now() == 12);
	}
};

behavior Main
{
	event	e1, e2, e3;
	A	a(e1, e2, e3);
	B	b(e1, e2, e3);

	int main(void)
	{
	puts("wait6: Starting...");

	par {	a.main();
		b.main();
		};

	puts("wait6: Done.");
	return(0);
	}
};

// EOF
