// try14.sc

#include <sim.sh>

#include <stdio.h>
#include <assert.h>

behavior Try(out event e)
{
	void main(void)
	{
	waitfor 1;
	notify e;
	waitfor 9;
	}
};

behavior TrapA(inout int x, out event e)
{
	void main(void)
	{
	x++;
	notify e;
	waitfor 1;
	}
};

behavior TrapB(inout int y, out event e)
{
	void main(void)
	{
	y++;
	notify e;
	waitfor 1;
	}
};

behavior InterruptA(inout int x, out event e)
{
	void main(void)
	{
	x++;
	notify e;
	}
};

behavior InterruptB(inout int y, out event e)
{
	void main(void)
	{
	y++;
	notify e;
	}
};

behavior Exception(inout int x, inout int y,
		inout event e1, inout event e2, inout event e3, inout event e4)
{
	Try		t(e3);
	TrapA		ta(x, e2);
	TrapB		tb(y, e1);
	InterruptA	ia(x, e4);
	InterruptB	ib(y, e1);

	void main(void)
	{
	try {	t.main();
		}
		trap e1
		    {	ta.main();
			}
		trap e2
		    {	tb.main();
			}
		interrupt e3
		    {	ia.main();
			}
		interrupt e4
		    {	ib.main();
			};
	}
};

behavior Trigger(out event e)
{
	void main(void)
	{
	waitfor 4;
	notify e;
	waitfor 1;
	}
};

behavior Main
{
	event		e1, e2, e3, e4, e5;
	int		x = 0;
	int		y = 0;

	Exception	e(x, y, e1, e2, e3, e4);
	Trigger		t1(e1),
			t2(e2),
			t3(e3),
			t4(e4),
			t5(e5);

	int main(void)
	{
	puts("try14: Starting...");

	e.main();
	assert(x == 2);
	assert(y == 1);
	assert(now() == 2);

	par {	e.main();
		t2.main();
		}
	assert(x == 4);
	assert(y == 2);
	assert(now() == 7);

	par {	e.main();
		t3.main();
		}
	assert(x == 6);
	assert(y == 3);
	assert(now() == 12);

	par {	e.main();
		t4.main();
		}
	assert(x == 8);
	assert(y == 4);
	assert(now() == 17);

	par {	e.main();
		t5.main();
		}
	assert(x == 10);
	assert(y == 5);
	assert(now() == 22);

	puts("try14: Done.");
	return(0);
	}
};

// EOF
