// try1.sc

#include <sim.sh>

#include <stdio.h>
#include <assert.h>

behavior Try
{
	void main(void)
	{
	waitfor 10;
	}
};

behavior TrapA(inout int x)
{
	void main(void)
	{
	x++;
	}
};

behavior TrapB(inout int y)
{
	void main(void)
	{
	y++;
	}
};

behavior InterruptA(inout int x)
{
	void main(void)
	{
	x++;
	}
};

behavior InterruptB(inout int y)
{
	void main(void)
	{
	y++;
	}
};

behavior Main
{
	event		e1, e2, e3, e4, e5;
	int		x = 0;
	int		y = 0;

	Try		t;
	TrapA		ta(x);
	TrapB		tb(y);
	InterruptA	ia(x);
	InterruptB	ib(y);

	int main(void)
	{
	puts("try1: Starting...");

	try {	t.main();
		}
		trap e1
		    {	ta.main();
			}
		trap e2
		    {	tb.main();
			};
	assert(x == 0);
	assert(y == 0);
	assert(now() == 10);

	try {	t.main();
		}
		interrupt e3
		    {	ia.main();
			}
		interrupt e4
		    {	ib.main();
			};
	assert(x == 0);
	assert(y == 0);
	assert(now() == 20);

	try {	t.main();
		}
		trap e1
		    {	ta.main();
			}
		trap e2
		    {	tb.main();
			}
		interrupt e3
		    {	ia.main();
			}
		interrupt e4
		    {	ib.main();
			};
	assert(x == 0);
	assert(y == 0);
	assert(now() == 30);

	try {	t.main();
		}
		trap e1, e2
		    {	ta.main();
			}
		trap (e2, e3)
		    {	tb.main();
			}
		interrupt e3
		    {	ia.main();
			}
		interrupt (e4, e5)
		    {	ib.main();
			};
	assert(x == 0);
	assert(y == 0);
	assert(now() == 40);

	puts("try1: Done.");
	return(0);
	}
};

// EOF
