/************************************************************************/
/* sim.cc: SpecC run-time simulation library				*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 03/21/01 */
/************************************************************************/

/* last update: 04/16/01 */

/* modifications: (most recent first)
 *
 * 04/16/01 RD	renamed "SIM_Time" to "sim_time";
 *		added string conversion functions
 * 04/05/01 RD	cosmetic change
 * 03/28/01 RD	clean up
 * 03/21/01 RD	initial version
 */


#include "sim.h"
#include "specc.h"
#include "longlong.h"
#ifdef DEBUG
#include "Global.h"
#endif /* DEBUG */

#include <assert.h>
#include <stdio.h>



/*** constants and macros ***********************************************/


	/* flag for DEBUG mode */

/* #define SIM_DEBUG */


/*** internal type declarations *****************************************/


	/* (none) */


/*** internal function prototypes ***************************************/


	/* (none) */


/*** internal variables *************************************************/


	/* (none) */


/*** exported variables *************************************************/


	/* (none) */


/************************************************************************/
/*** implementation of internal functions			      ***/
/************************************************************************/


	/* (none) */


/************************************************************************/
/*** implementation of exported functions			      ***/
/************************************************************************/


sim_time now(void)		/* obtain current simulation time */
{

return(_specc::getCurrentTime());

} /* end of now */


const char *time2str(		/* convert time to printable string */
	sim_time	Time)		/* (copy temporary internal buffer!) */
{
static char Buffer[40];	/* sufficient space for 64bit time values */

return(ull2str(10, &Buffer[39], Time));	/* time is 'unsigned long long' */

} /* end of time2str */


sim_time str2time(		/* convert printable string to time */
	const char	*str)
{

return(str2ull(10, str));		/* time is 'unsigned long long' */

} /* end of str2time */


/************************************************************************/
/*** main (for debugging only)					      ***/
/************************************************************************/


#ifdef DEBUG	/* module self test */


int main(int argc, char **argv)
{
sim_time	CurrTime,
		Time1,
		Time2,
		Time3;

printf("DEBUGGING: SimLib ('%s')\n\n", argv[0]);
if (argc != 1)
   { puts("WARNING: Arguments will be ignored!\n");
    } /* fi */

puts("Testing functions now() and time2str()...");
CurrTime = now();
printf("Current time is now %s.\n", time2str(CurrTime));
if (CurrTime != 0)
   { puts("ERROR: Current time does not start from zero!\n"
		"Aborted.");
     exit(RESULT_ERROR);
    } /* fi */

puts("Testing functions str2time() and time2str()...");
Time1 = str2time("15000000000");
Time2 = str2time("27000000000");
Time3 = Time1 + Time2;
printf("15s + 27s = %sns.\n", time2str(Time3));
if (Time3 != str2time("42000000000"))
   { puts("ERROR: Time computation problem!\n"
		"Aborted.");
     exit(RESULT_ERROR);
    } /* fi */

puts("\nDone.");
return(RESULT_OK);

} /* end of main */

#endif /* DEBUG */


/* EOF sim.cc */
