/* T.sc: test file for some crazy/interesting things	*/
/* -----						*/


extern void printf(const char*, ...);

int Flag = 1;
extern Flag;

interface R { };

interface L
{
void Write(int Value);
};

interface L2
{
void Write(int Value);
void GetNextBit(void);	/* historical: was of callback storage class */

note GetNextBit.Comment	= "This interface is just for fun!";
};

typedef int	myint;

note L2.Comment		= "This interface is just for fun!";
note L2.costs		= 15000 * (17 -3);
note myint.why		= "just to have some fun!";

behavior X (out int p1, L p2, int p3)
{ void main(void){} };
behavior Y (in int p1, L p2, int p3)
{ void main(void){} };

channel C(void) implements L, R
{
int	Storage;
bool	Valid;

void Write(int Value)
{
Storage = Value;
Valid = true;
}

int Read(void)
{
while(! Valid)
     ;
return(Storage);
}

note Read.Text = "The quick brown fox jumps over the lazy dog.";
}; /* end of channel C */

behavior T(in int p1, inout int p2, R p3)
{
const int	IntegerInitializedByBitvector = 1111b;
//struct S { int x, y; } s = { 10, 20 };	// unsupported!

piped int	C1;
C		C2;

X		x(C1, C2, Flag);	// x(C1, C2, p1);
Y		y(C1, C2, p2);

void main(void)
{
piped int UnusedPipe;

pipe{ x.main();
      y.main();
     };
}

}; /* end of behavior T */

//channel CZ(void){};	// useless warning!

//	channel CY(int, CZ){};	/* channel-type ports disallowed */
//	channel CX(CY, CZ){};	/* (Oct 12, 98) */

struct XYZ { int i;};
behavior T2(inout int p1, out int p2, R p3, event e4, struct XYZ aXYZ)
{
int	C1 = 5;		/* initializer in classes */
C	C2;

X	x(C1, C2, p1);
Y	y(C1, C2, p1);
T	t(p1, p1, p3);

//CZ	cz;

event	e1, e2, e3;

void TimingDiagram(void)
{
int	Address, a, Read;

do	{ t1: { Address = a; }
	  t2: { Read = 1; }
	  t3: { }
	  t4: { }
	}
timing
	{ range(t1; t2; 10; 20);
	  range(t2; t3;  0;   );
	  range(t3; t4;   ;  8);
	}
}

void EventDemo(void)
{
notify e1;
waitfor 10;
notify(e2, e3);
wait e2, e3;
notifyone(e1, e2, e3);
}

void EventExpressions(void)	// test for bug fix 10/10/02
{
event e;

//if (e)		// before: leads to problem in C++ compilation
			// now:    detailed error message in SpecC compiler
	wait e;

//e;			// before: problem not detected!
			// now:    detailed error message in SpecC compiler
//e,e;			// same here!
}

void main(void)
{
try{ t.main(); }
	trap (e1, e2)	{ y.main(); }
	interrupt (e4)	{ x.main(); }
	trap (e3)	{ x.main(); }
}

}; /* end of behavior T2 */


static int foo(int x)
{
bit[1:8]	b;

b = b[8:1][3:1][0:2];

return(x*x);
}

void LoopsEtc(void)
{
int	i;

for(i=0; i<10; i++)
	;
for( ; ; )
	;
while()
	;
do { } while (true);

}

void FormattedExpressionsEtc(void)	/* (11/01/01, RD) */
{
	int	a, b, c, d, e, f;

	a = (   (a * 2)
		+
		(b * 3)
	    )
	    -
	    (   (c / 8)
		+
		(d / 5)
	    );
	a = (b = ((a * 2) + (b * 3)) -
		((c / 8) + (d / 5)));
	printf("%d %d %d %d %d %d\n",
		a, b, c, d, e, f);
	printf("This is a test.\n"
		"And now some values: %d %d\n"
		"%d %d %d %d\n",
		a, b,
		c, d, e, f);
	printf("This is another test.\n"
		"And now some values: %d %d\n"
		"%d %d %d %d\n",
		(a * b),
		(b * 3),
		( (a * 2)
		  +
		  (b * 3)
		)
		-
		(
			(
				(c / 8) * 4 + 3 * 2
			)
			+
			(
				d / 5
			)
		),
		d, e, f);
	if ( a + a + a + a + a + a + a + a + a >=
		b + b + b + b + b + b + b + b + b + b)
		c = d;
	else
		d = c;
	for (	a = 1234567;
		b < a + a + a + a + a + a + a + a;
		c++)
		a += b;
}

// piped GlobalPipe;	// not allowed!

int f42(int x)
{
piped	LocalFctPipe;	// useless!

return 42*x;
}

//behavior Dumb(piped port);	// not allowed!

behavior TestCase1ForMethodDeclarations
{
	void MethodA(void);	// redundant method declaration
	void MethodB(void);	// non-redundant method declaration
	void MethodC(void);	// non-redundant method declaration

	void MethodA(void)	// definition of method A
	{
		MethodB();
	}

	void MethodB(void)	// definition of method B
	{
		MethodA();
	}

	void main(void)
	{
		// nothing
	}
};

behavior TestCase2ForMethodDeclarations
{
	void MethodB(void);	// redundant method declaration
	void MethodA(void);	// non-redundant method declaration
	void MethodC(void);	// non-redundant method declaration

	void MethodB(void)	// definition of method A
	{
		MethodA();
	}

	void MethodA(void)	// definition of method B
	{
		MethodB();
	}

	void main(void)
	{
		// nothing
	}
};

// was: CompBug.sc
// (discovered by Kiran Ramineni <kiran@ics.uci.edu>)
// (fixed 01/06/03 by R.D)

void f(void)
{
char a[10];
char *p;
void (*f0)(void);	// pointer to void function with void args

a != p;	// was: Invalid operand for comparison operator (#2194)
f != f0;// same here!

}

/* EOF */
