// FSM3.sc:

#include "../../inc/sim.sh"	// <sim.sh>
#include <stdio.h>


bool	Condition1 = false,
	Condition2 = true;

behavior State1 (event clk)
{
	void main(void)
	{
	printf("Time =%5s : State 1 active...\n", time2str(now()));
	wait(clk);
	}
};

behavior State2 (event clk)
{
	void main(void)
	{
	printf("Time =%5s : State 2 active...\n", time2str(now()));
	wait(clk);
	}
};

behavior State3 (event clk)
{
	void main(void)
	{
	printf("Time =%5s : State 3 active...\n", time2str(now()));
	wait(clk);
	}
};

behavior State41 (event clk)
{
	void main(void)
	{
	printf("Time =%5s : State 4.1 active...\n", time2str(now()));
	wait(clk);
	}
};

behavior State42 (event clk)
{
	void main(void)
	{
	printf("Time =%5s : State 4.2 active...\n", time2str(now()));
	wait(clk);
	}
};

behavior State43 (event clk)
{
	void main(void)
	{
	printf("Time =%5s : State 4.3 active...\n", time2str(now()));
	wait(clk);
	}
};

behavior State44 (event clk)
{
	void main(void)
	{
	printf("Time =%5s : State 4.4 active...\n", time2str(now()));
	wait(clk);
	}
};

behavior State4 (event clk)
{
    State41	S41(clk);
    State42	S42(clk);
    State43	S43(clk);
    State44	S44(clk);

    int		i=0;

    void main(void)
    {
	fsm{ S41: /* default: goto next state */
	     S42:
		{ if (++i < 2) goto S42;
		  goto S43;
		 }
	     S43:
		{ if (i=0, true) goto S44;
		  goto S43;
		  break;
		  goto S43;
		 }
	     S44:
		{ if (++i < 4) goto S44;
		  if (false) goto S44;
		  if (true) break;
		  goto S41;
		 }
	    }
    }
};

behavior State5 (event clk)
{
	void main(void)
	{
	printf("Time =%5s : State 5 active...\n", time2str(now()));
	wait(clk);
	}
};

behavior State6 (event clk)
{
	void main(void)
	{
	printf("Time =%5s : State 6 active...\n", time2str(now()));
	wait(clk);
	}
};

behavior FSM (event clk)
{
	State1	S1(clk);
	State2	S2(clk);
	State3	S3(clk);
	State4	S4(clk);
	State5	S5(clk);
	State6	S6(clk);

	void main(void)
	{
	fsm{ S1: /* default: goto next state */
	     S2:
		{ if (Condition1)
			goto S2;
		  /* else */
			goto S3;
		 }
	     S3:
		{ if (Condition2 || Condition1)
			goto S4;
		  goto S2;
		 }
	     S4:
		{ /* default: goto next state */
		 }
	     S5:
		{ if (Condition1)
			goto S4;
		  if (! Condition2)
			goto S5;
		 }
	     S6:
		{ if (Condition1)
			goto S3;
		  if (Condition1 && !Condition2)
			goto S4;
		  break;
		 }
	    }
	}
};

behavior Clock (event clk)
{
	void main(void)
	{
	int	i;
	for(i=1; i<20; i++)
		{
		waitfor(100);
//		printf("Time =%5s : Clock-tick!\n", time2str(now()));
		notify(clk);
		}
	}
};

behavior Main
{
	event	SystemClock;
	Clock	ClockGen(SystemClock);
	FSM	MyFSM(SystemClock);

	int main(void)
	{
	puts("Starting...");
	par {	ClockGen.main();
		MyFSM.main();
		}
	puts("Exiting...");
	return(0);
	}
};

// EOF
