// AnonEnum.sc: regression test for bug fix
// (last change 04/25/02, RD)

// original bug reported by Andreas, 02/26/02:

behavior Main0()	// was: Main
{
  void main(void)
  {
    int i1, i2;

    enum { S0, S1, S2 } state;
    state = S0;

    while(state != S2)
    {
      switch(state) {
        case S0:
	case S1:	// wasn't handled, created warning
	case S2:	// wasn't handled, created warning
          state = S2;
          break;
      }
    }
  }
};

// modifications (by RD)

enum /* anonymous */ { e1, e2, e3 } E, E2, E3[2], *E4;

// extensions (by RD)

struct /* anonymous */ { int i1, i2; } S, SS2, S3[2], *S4;

// other test cases

enum { zero, one, two, three };
int One = one;

enum { b0, b1, b2 } bug1, bug2;

typedef enum { red, yellow, green } traffic_light;
traffic_light light;


// finally, make it an executable example (regression test)

behavior Main
{
  int main(void)
  {
    enum { state0, state1, state2 } state;
    state = state0;

    while(state != state2)
    {
      switch(state) {
        case state0:
	  light = red;
          state = state1;
          break;
        case state1:
	  light = yellow;
          state = state2;
          break;
        case state2:
	  light = green;
          state = state2;
          break;
      }
    }
    return(0);
  }
};

// EOF
