// i_consumer.sc: consumer interface to token channel
// (a consumer thread receives a number of tokens from a producer thread)
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 02/12/02 RD	applied naming convention, integrated with distribution
// 02/06/02 RD	initial version (based on generalized handshake.sc)
//
//
// interface rules:
//
// - consumer interface to a token channel as known from Petri nets
// - each connected thread acts as a consumer
// - a consumer calls consume(n) to consume n tokens
// - a call to consume() will return immediately if the requested number
//   of tokens are already present, consuming those tokens
// - a call to consume() will block the caller if not enough tokens
//   are present, until a sufficient number of tokens has been produced
// - calling consume() may suspend the calling thread indefinitely


interface i_consumer
{
    void consume(unsigned long n);
};


// EOF i_consumer.sc
