// typed_queue_test2.sc: test bench for c_typed_queue.sh
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 04/25/03 RD	changed receiver interface to support array types
// 02/14/02 RD	applied naming convention, integrated with distribution
// 02/06/02 RD	cleared up after bugfix in bitlib
// 02/05/02 RD	initial version (type bit[64], 1 sender, 1 receiver)


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <sim.sh>


#define QUEUE_SIZE	20	// length of the queue
#define N		100	// number of read and write transactions


import "c_bit64_queue";
//import "c_bit64_queue_dbg";	// use this to debug the channel!


int Rnd(int Range)		// random number in range [0...Range-1]
{
    return((unsigned int)(drand48() * (double)Range));
}


behavior Sender(
    i_bit64_sender Queue)
{
    void SendData(int s)
    {
	bit[64] Data;

	printf("Time%4s: Sender storing data %d.\n",
		time2str(now()), s);
	Data = s @ s;
	Queue.send(Data);
    }

    void Sleep(void)
    {
	int Duration;

	printf("Time%4s: Sender done, ",
		time2str(now()));
	Duration = Rnd(10);
	printf("going to sleep for %d time units.\n", Duration);
	if (Duration)
	    waitfor(Duration);
    }

    void main(void)
    {
	int s;

	for(s=1; s<=N; s++)
	{
	    SendData(s);
	    Sleep();
	}
    }
};


behavior Receiver(
    i_bit64_receiver Queue)
{
    void ReceiveData(int r)
    {
	bit[64] Data;

	printf("Time%4s: Receiver loading data %d.\n",
		time2str(now()), r);
	Queue.receive(&Data);
	assert(Data == r @ r);
    }

    void Sleep(void)
    {
	int Duration;

	printf("Time%4s: Receiver done, ",
		time2str(now()));
	Duration = Rnd(10);
	printf("going to sleep for %d time units.\n", Duration);
	if (Duration)
	    waitfor(Duration);
    }

    void main(void)
    {
	int r;

	for(r=1; r<=N; r++)
	{
	    ReceiveData(r);
	    Sleep();
	}
    }
};


behavior Main			// test bench for typed_queue
{
    c_bit64_queue Queue(((const unsigned long)QUEUE_SIZE));
    Receiver      r1(Queue);
    Sender        s1(Queue);

    int main(void)
    {
	printf("Time%4s: typed_queue_test2: Starting...\n",
		time2str(now()));
	printf("Time%4s: Running 1 receiver, 1 sender, "
			"using data type 'bit[64]'.\n",
		time2str(now()));
	par {	r1.main();
		s1.main();
		}
	printf("Time%4s: typed_queue_test2: Done.\n",
		time2str(now()));
	return 0;
    }
};


// EOF typed_queue_test2.sc
