// handshake_test1.sc: test bench for c_handshake.sc
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 02/19/02 RD	completed contents
// 02/18/02 RD	initial version (based on double_handshake_test.sc)


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <sim.sh>


#define N	30	// number of handshake transactions
			// (even number!)


import "c_handshake";


int Rnd(int Range)		// random number in range [0...Range-1]
{
    return((unsigned int)(drand48() * (double)Range));
}


behavior Sender(
    i_send  Handshake,
    out int Data)
{
    void Send(void)
    {
	printf("Time%4s: Sender sending a handshake.\n",
		time2str(now()));
	Handshake.send();
    }

    void Sleep(void)
    {
	int Duration;

	Duration = Rnd(3);
	printf("Time%4s: Sender going to sleep for %d time units.\n",
		time2str(now()), Duration);
	if (Duration)
	    waitfor(Duration);
    }

    void main(void)
    {
	Sleep();
	Data = 42;
	Send();
	Sleep();
    }
};


behavior Receiver(
    i_receive Handshake,
    in int    Data)
{
    void Receive()
    {
	printf("Time%4s: Receiver receiving handshake.\n",
		time2str(now()));
	Handshake.receive();
    }

    void Sleep(void)
    {
	int Duration;

	Duration = Rnd(3);
	printf("Time%4s: Receiver going to sleep for %d time units.\n",
		time2str(now()), Duration);
	if (Duration)
	    waitfor(Duration);
    }

    void main(void)
    {
	Sleep();
	Receive();
	assert(Data == 42);
	Sleep();
    }
};


behavior Main			// test bench for handshake
{
    c_handshake Handshake;
    int         Data;
    Receiver    r1(Handshake, Data);
    Sender      s1(Handshake, Data);

    int main(void)
    {
	int i;

	printf("Time%4s: handshake_test1: Starting...\n",
		time2str(now()));
	for(i=0; i<N/2; i++)
	{
	    Data = 0;
	    par {   r1.main();
		    s1.main();
		}
	}
	for(i=0; i<N/2; i++)
	{
	    Data = 0;
	    par {   s1.main();
		    r1.main();
		}
	}
	printf("Time%4s: handshake_test1: Done.\n",
		time2str(now()));
	return 0;
    }
};


// EOF handshake_test1.sc
