// try31.sc

#include <sim.sh>

#include <stdio.h>
#include <assert.h>

behavior Try
{
	void main(void)
	{
	waitfor 10;
	}
};

behavior TrapA(inout int x)
{
	void main(void)
	{
	x++;
	}
};

behavior InterruptA(inout int x)
{
	void main(void)
	{
	x++;
	}
};

behavior Exception(inout int x, inout int y,
		in event e1, in event e2, in event e3, in event e4)
{
	Try		t;
	TrapA		ta(x);
	InterruptA	ia(x);

	void main(void)
	{
	try { t; }
		trap e1 { ta; }
		trap e2 {     }
		interrupt e3 { ia; }
		interrupt e4 {     }
	}
};

behavior Exception0(inout int x, inout int y,
		in event e1, in event e2, in event e3, in event e4)
{
	TrapA		ta(x);
	InterruptA	ia(x);

	void main(void)
	{
	try {	}
		trap e1 { ta; }
		interrupt e3 { ia; }
	}
};

behavior Trigger(out event e)
{
	void main(void)
	{
	waitfor 5;
	notify e;
	}
};

behavior Main
{
	event		e1, e2, e3, e4, e5;
	int		x = 0;
	int		y = 0;

	Exception	e(x, y, e1, e2, e3, e4);
	Exception0	e0(x, y, e1, e2, e3, e4);
	Trigger		t1(e1),
			t2(e2),
			t3(e3),
			t4(e4),
			t5(e5);

	int main(void)
	{
	puts("try31: Starting...");

	par {	e; t1; }

	assert(x == 1);
	assert(y == 0);
	assert(now() == 5);

	par {	e; t2; }

	assert(x == 1);
	assert(y == 0);
	assert(now() == 10);

	par {	e; t3; }

	assert(x == 2);
	assert(y == 0);
	assert(now() == 20);

	par {	e; t4; }

	assert(x == 2);
	assert(y == 0);
	assert(now() == 30);

	par {	e0; t5; }

	assert(x == 2);
	assert(y == 0);
	assert(now() == 35);

	puts("try31: Done.");
	return(0);
	}
};

// EOF
