// notifyone9.sc

#include <sim.sh>

#include <stdio.h>
#include <assert.h>

behavior A(in event e1, in event e2, inout int x)
{
	void main(void)
	{
	int	i;

	for(i=0; i<100; i++)
	   { wait e1 && e2;
	     x++;
	    }
	}
};

behavior B(in event e1, in event e2, inout int y)
{
	void main(void)
	{
	int	i;

	for(i=0; i<100; i++)
	   { wait e1 && e2;
	     y++;
	    }
	}
};

behavior C(out event e1, out event e2, in int x, in int y)
{
	void main(void)
	{
	int	i;

	for(i=0; i<10; i++)
	   { notifyone e1;
	     notifyone e2;
	     notifyone e1;
	     notifyone e2;
	     waitfor(1);
	    }
	assert(x == 10);
	assert(y == 10);

	for(i=0; i<10; i++)
	   { notifyone e1;
	     notifyone e1;
	     notifyone e2;
	     notifyone e2;
	     waitfor(1);
	    }
	assert(x == 20);
	assert(y == 20);

	for(i=0; i<10; i++)
	   { notifyone e2;
	     notifyone e2;
	     notifyone e1;
	     notifyone e1;
	     waitfor(1);
	    }
	assert(x == 30);
	assert(y == 30);

	for(i=0; i<70; i++)
	   { notifyone e1;
	     notifyone e2;
	     notifyone e1;
	     notifyone e2;
	     waitfor(1);
	    }
	assert(x == 100);
	assert(y == 100);
	}
};

behavior Main
{
	event	e1, e2;
	int	x = 0;
	int	y = 0;
	A	a(e1, e2, x);
	B	b(e1, e2, y);
	C	c(e1, e2, x, y);

	int main(void)
	{
	puts("notifyone9: Starting...");

	par {	a.main();
		b.main();
		c.main();
		};
	assert(x + y == 200);
	assert(now() == 100);

	puts("notifyone9: Done.");
	return(0);
	}
};

// EOF
