// MultGen.sc: test case for 'sir_gen'
//
// 01/12/04 AG	_SIR_MANGLED_SUFFIX not a string any more
// 04/09/03 AG	added globals to check name mangling
// 11/07/02 AG	update to new range format
// 11/05/02 RD	integrated with 'scc' package
// 11/03/02 AG	initial version (test.sc)

#define STR(a,b)  #a #b
#define NAME(a,b) STR(a,b)

#define BITWIDTH_DFLT 32

#ifndef _SIR_MANGLED_SUFFIX
#define _SIR_MANGLED_SUFFIX
#endif

#ifndef BITWIDTH
#define BITWIDTH BITWIDTH_DFLT
#endif

behavior mult(out unsigned bit[BITWIDTH-1:0] o,
              in  unsigned bit[BITWIDTH-1:0] a,
              in  unsigned bit[BITWIDTH-1:0] b,
              in  event clk)
{
  // library information    
  note mult._RT_LIBRARY = true;
  note mult._RT_CATEGORY = "FU";
  note mult._RT_OPERATION = "*";

  // attributes
  note mult._RT_CLOCK = { 100e6, 1.0, 100e6 };
  note mult._RT_BITWIDTH = BITWIDTH;
  
  // unit information  
  note mult._RT_OUTPUT_DELAY= 1.0;    
  note mult._RT_STAGES = 1;
  
  // area/cost information	
  note mult._RT_AREA= 600.0;   
  note mult._RT_COST= 8.0;	
  note mult._RT_POWER = 0.3;

  // information about additional models
  note mult._RT_BF_MODEL = NAME(mult_BF,_SIR_MANGLED_SUFFIX);
  
  // parameters
  note mult._SIR_PARAMETERS = {
    { "BITWIDTH", BITWIDTH_DFLT, { 8, 16, {32, 128} }, "Bitwidth", "bits" }
  };
  		
  void main(void)
  {
    static bit[BITWIDTH-1:0] product;
    
    o = product;
    product = a * b;
  }
};

// extern behavior
behavior mult_BF();

// global variable and function
int mult_var;
int mult_func(void) {
  return 0;
}

// extern variable and function
extern int ext_var;
int ext_func(void);

