/************************************************************************/
/* IntRep/FsmdState.h: SpecC Internal Representation, FsmdState Class	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 02/03/03 */
/************************************************************************/

/* last update: 06/15/04 */

/* modifications: (most recent first)
 *
 * 06/15/04 PC  Adjustments for scrc 2.0
 * 11/04/03 RD	added SIR_FsmdState::CreateReachableTree()
 * 11/03/03 RD	added method CollectReachableStates(), member NextStates,
 *		and methods AttachDelayedAssignments()
 * 10/31/03 RD	added classes SIR_StatePtr and SIR_StatePtrs
 * 10/02/03 RD	added member DelayedAssgns to SIR_FsmdState
 * 04/07/03 RD	added SIR_FsmdStates::CreateNewStateName()
 * 02/13/03 RD	added support for annotation of states
 * 02/07/03 RD	added methods Declare(), Define(), CheckAllDefined()
 * 02/06/03 RD	refined/extended/added methods
 * 02/05/03 RD	declared members and methods
 * 02/03/03 RD	initial version
 */


#ifndef INTREP_FSMDSTATE_H
#define INTREP_FSMDSTATE_H


#include "Global.h"
#include "IntRep/FsmdStmnt.h"


/*** enumeration types **************************************************/


	/* (none) */


/*** type definitions ***************************************************/


typedef class SIR_FsmdState		sir_fsmdstate;
typedef SIR_List<sir_fsmdstate>		sir_fsmdstate_list;
typedef class SIR_FsmdStates		sir_fsmdstates;
typedef ERROR 			(*sir_fsmdstate_fct)(sir_fsmdstate*, void*);
typedef struct SIR_FsmdStateRep		sir_fsmdstate_rep;
typedef struct SIR_FsmdStatesRep	sir_fsmdstates_rep;
typedef void *				sir_fsmdstate_marg;
typedef ERROR (SIR_FsmdState::*sir_fsmdstate_mptr)(void*);
typedef struct SIR_FsmdStateUarg
	{
	sir_fsmdstate_fct	CallerFct;
	void			*CallerArg;
	}				sir_fsmdstate_uarg;

typedef class SIR_StatePtr		sir_state_ptr;
typedef SIR_List<sir_state_ptr>		sir_state_ptr_list;
typedef class SIR_StatePtrs		sir_state_ptrs;


/*** class declarations *************************************************/


	/*********************/
	/*** SIR_FsmdState ***/
	/*********************/


class SIR_FsmdState :			/* fsmd state */
	public SIR_Node,			/* is a node */
	public SIR_ListElem<SIR_FsmdState>	/* and a list element */
{
public:
string		StateName;	/* identifier of the state */
sir_fsmdstmnt	*CmpndStmnt;	/* statements executed in this state */
sir_notes	*Notes;		/* notes for this state (NULL if none) */

sir_dlydassgns	*DelayedAssgns;	/* delayed assignments ('piped'/'after') */
sir_state_ptrs	*NextStates;	/* reachable next states (temporarily) */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_FsmdState(				/* constructor #1 */
	const char	*StateName,
	sir_fsmdstmnt	*CmpndStmnt = NULL,
	unsigned int	Line = 0,
	sir_fileinfo	*FileInfo = NULL);

SIR_FsmdState(				/* constructor #2 (from ext. rep.) */
	sir_fsmdstate_rep *StateRep,
	const char	*Name);

SIR_FsmdState(				/* constructor #6 (duplicator) */
	sir_fsmdstate	*Original);

~SIR_FsmdState(void);			/* destructor */


ERROR DFS_ForAllNodes(		/* iterator over all nodes (depth first) */
	sir_node_mptr	MemberFct,
	sir_node_marg	MemberFctArg);

ERROR DFS_ForAllSymbols(	/* iterator over all symbols (depth first) */
	sir_symbol_mptr	MemberFct,
	sir_symbol_marg	MemberFctArg);

ERROR DFS_ForAllUserTypes(	/* iterator over all usertypes (depth first) */
	sir_usertp_mptr	MemberFct,
	sir_usertp_marg	MemberFctArg);

ERROR DFS_ForAllNotes(		/* iterator over all notes (depth first) */
	sir_note_mptr	MemberFct,
	sir_note_marg	MemberFctArg);

ERROR DFS_ForAllFsmdStmnts(	/* iterator over all fsmd statements (dfs) */
	sir_fsmdstmnt_mptr	MemberFct,
	sir_fsmdstmnt_marg	MemberFctArg);

ERROR DFS_ForAllExpressions(	/* iterator over all expressions (dfs) */
	sir_expr_mptr	MemberFct,
	sir_expr_marg	MemberFctArg);

void SetAlias(			/* sets all type, usertype, symbol alias' */
	sir_fsmdstate	*Alias);/* (iterates over symbols and usertypes) */

void UnAlias(			/* unalias all type, usertype, symbol links */
	sir_symbols	*GlobalSymbols);


ERROR WriteSC(			/* (re-) generates SpecC source code */
	GL_HANDLE	*IO,
	BOOL		WriteNotes,
	BOOL		CplusplusMode = FALSE,
	BOOL		PutNewLine = TRUE);

#ifndef NDEBUG
const char *Print(void);	/* print SpecC code */
#endif /* NDEBUG */


ERROR Annotate(			/* attach a note to the state (#1) */
	sir_note	*NewNote);	/* (consumes NewNote) */

ERROR AttachDelayedAssignments(	/* attach delayed assignment to this state */
	sir_delydassgn	*Assignment);	/* (and the next states) */


void CreateReachableTree(	/* recursively create reachable state tree */
	void);

sir_fsmdstates *GetList(void);  /* obtain a pointer to the state list */

sir_state_ptrs *CollectReachableStates( /* collect all reachable next states */
        void);                          /* from here (returns new list!) */

sir_statement *GetStatement(    /* obtain a pointer to the 'fsmd' statement */
        void);
};


	/**********************/
	/*** SIR_FsmdStates ***/
	/**********************/


class SIR_FsmdStates :			/* sequence of fsmd states */
	public SIR_List<SIR_FsmdState>	/* is simply a list of states */
{					/* with additional methods    */
public:


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_FsmdStates(			/* constructor #1 */
	sir_fsmdstate	*FirstEntry = NULL);

SIR_FsmdStates(			/* constructor #2 (from ext. rep.) */
	sir_fsmdstates_rep	*StatesRep);

SIR_FsmdStates(			/* constructor #3 (duplicator) */
	sir_fsmdstates	*Original);

~SIR_FsmdStates(void);		/* destructor */


sir_fsmdstate *Declare(		/* declare a (possibly new) state */
	const char	*StateName);	/* (always succeeds) */

sir_fsmdstate *Define(		/* define a (possibly new) state */
	const char	*StateName,	/* (may return NULL and SIR_Error) */
	sir_fsmdstmnt	*CmpndStmnt,
	unsigned int	Line = 0,
	sir_fileinfo	*FileInfo = NULL);

ERROR CheckAllDefined(		/* check whether all states are defined */
	void);


ERROR DFS_ForAllNodes(		/* iterator over all nodes (depth first) */
	sir_node_mptr	MemberFct,
	sir_node_marg	MemberFctArg);

ERROR DFS_ForAllSymbols(	/* iterator over all symbols (depth first) */
	sir_symbol_mptr	MemberFct,
	sir_symbol_marg	MemberFctArg);

ERROR DFS_ForAllUserTypes(	/* iterator over all usertypes (depth first) */
	sir_usertp_mptr	MemberFct,
	sir_usertp_marg	MemberFctArg);

ERROR DFS_ForAllNotes(		/* iterator over all notes (depth first) */
	sir_note_mptr	MemberFct,
	sir_note_marg	MemberFctArg);

ERROR DFS_ForAllFsmdStmnts(	/* iterator over all fsmd statements (dfs) */
	sir_fsmdstmnt_mptr	MemberFct,
	sir_fsmdstmnt_marg	MemberFctArg);

ERROR DFS_ForAllExpressions(	/* iterator over all expressions (dfs) */
	sir_expr_mptr	MemberFct,
	sir_expr_marg	MemberFctArg);

void SetAlias(			/* sets all type, usertype, symbol alias' */
	sir_fsmdstates	*Alias);/* (iterates over symbols and usertypes) */

void UnAlias(			/* unalias all type, usertype, symbol links */
	sir_symbols	*GlobalSymbols);

sir_fsmdstate *Find(            /* find a fsmd state in this list */
        const char      *StateName);    /* (returns NULL if not found) */
};


	/********************/
	/*** SIR_StatePtr ***/
	/********************/


class SIR_StatePtr :			/* fsmd state pointer */
	public SIR_ListElem<SIR_StatePtr>	/* is a list element */
{
public:
sir_fsmdstate	*State;		/* link to fsmd state (NULL for 'break') */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_StatePtr(			/* constructor #1 */
	sir_fsmdstate	*State);

SIR_StatePtr(			/* constructor #2 (duplicator) */
	sir_state_ptr	*Original);

~SIR_StatePtr(void);		/* destructor */


};


	/*********************/
	/*** SIR_StatePtrs ***/
	/*********************/


class SIR_StatePtrs :		/* list of fsmd state pointers */
	public SIR_List<SIR_StatePtr>	/* is basically a list */
{					/* with additional functions */
public:

//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_StatePtrs(			/* constructor #1 */
	sir_state_ptr	*FirstEntry = NULL);

SIR_StatePtrs(			/* constructor #2 (duplicator) */
	sir_state_ptrs	*Original);

~SIR_StatePtrs(void);		/* destructor */


static int Cmp(			/* comparison for list ordering */
	sir_fsmdstate	*State1,	/* (just as strcmp()) */
	sir_fsmdstate	*State2);


ERROR AttachDelayedAssignments(	/* attach delayed assignments to these states */
	sir_delydassgn	*Assignment);

sir_state_ptrs *Add(            /* add a state to the state pointer set */
        sir_fsmdstate   *State);

sir_state_ptrs *Join(           /* join two lists of state pointers */
        sir_state_ptrs  *Other);        /* (consumes Other list) */
};


/*** exported functions *************************************************/


	/* none */


#endif /* INTREP_FSMDSTATE_H */

/* EOF IntRep/FsmdState.h */
