/************************************************************************/
/* System.cc: utility to determine system dependent properties		*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 11/14/01	*/
/************************************************************************/

/* last update: 11/15/01 */

/* modifications: (most recent first)
 *
 * 11/15/01 RD	support to distinguish 'gcc' 2.9x and 3.0.x class layout
 * 11/14/01 RD	initial version
 */

#include <stdio.h>
#include <assert.h>

// #define DEBUG


class VPtrLocator
{
public:
void	*p;
virtual void m(void);
};


void VPtrLocator::m(void)
{
// nothing
}


int main(void)
{
VPtrLocator	v;

puts(	"// GL_System.h: System dependent header file\n"
	"\n"
	"// (automatically generated by 'System.cc')\n"
	"\n"
	"\n"
	"#ifndef GL_SYSTEM_H\n"
	"#define GL_SYSTEM_H"
	"\n");

#ifdef DEBUG
printf(	"// sizeof(v)   = %d\n", sizeof(v));
printf(	"// sizeof(v.p) = %d\n", sizeof(v.p));
printf(	"// &v          = %p\n", &v);
printf(	"// &v.p        = %p\n", &v.p);
#endif /* DEBUG */

assert(sizeof(v) > sizeof(v.p));	/* there must be a vptr.! */
assert(sizeof(v) == 2*sizeof(v.p));	/* should be std. pointer */
if (((unsigned long)&v) == ((unsigned long)&v.p))
   { puts("#define GL_SYSTEM_VPTR_IS_LAST_IN_CLASS"); // (e.g. gcc 2.95.2)
    } /* fi */
else
   { assert(  (((unsigned long)&v) == ((unsigned long)&v.p - sizeof(v.p)))
	    ||(((unsigned long)&v) == ((unsigned long)&v.p + sizeof(v.p))));
     puts("#define GL_SYSTEM_VPTR_IS_FIRST_IN_CLASS"); // (e.g. gcc 3.0.2)
    } /* esle */

puts(	"\n"
	"#endif /* GL_SYSTEM_H */\n"
	"\n"
	"\n"
	"/* EOF */");

} /* end of main */


/* EOF */
