// After.sc: test cases for 'after'/'piped' clauses in 'fsmd' statement

behavior Fsmd(in bit[8] p1, in bit[8] p2, out bit[8] p3)
{
    void main(void)
    {   
	buffered[10u] bit[7:0] i;
	bit[8] sum1, sum2, pro1, product, product2, xxxx;
	bit[8] pipe_over_loop, WARN1, WARN2, WARN3, WARN4, WARN5, WARN6;
	bit[8] ERROR1;
	bool status;

	fsmd(10u){
	    S0:
	    {
		sum1 = sum2 = 0;
		WARN1 = p1 after 5;	// [7] WARNING EXPECTED!
		goto S01;
	    }
	    S01:
	    {
		sum1 = p1 + p2 after 2;
		sum2 = p1 + p2 after 2;	// [1] unintended after-after collision
		pro1 = p1 * p2 piped 3;	// [3] unintended piped-piped collision
		xxxx = p1 * p2 piped 2;	// [5] unintended piped-after collision
		WARN1 = p2 piped 4;	// [7] WARNING EXPECTED!
		goto S02;
	    }
	    S02:
	    {
		sum2 = p2 + 2 after 1;	// [1] unintended after-after collision
		pro1 = p1 * 2 piped 2;	// [3] unintended piped-piped collision
		xxxx = p1 + p2 after 2;	// [5] unintended piped-after collision
		goto S03;
	    }
	    S03:
	    {
		goto S04;
	    }
	    S04:
	    {
		product = p1 * p2 piped 3;
		sum2 = p1 + p2 after 2;
		goto S05;
	    }
	    S05:
	    {
		goto S06;
	    }
	    S06:
	    {
		goto S07;
	    }
	    S07:
	    {
		product2 = p1 * p2 piped 3;
		WARN4 = 4 piped 3;	// [10] WARNING EXPECTED! (actually 2!)
		goto if_start;
	    }
	    if_start:
	    {
		product = p1 * p2 piped 3;
		WARN4 = 4 after 2;	// [10] WARNING EXPECTED! (actually 2!)
		if (p1 > p2)
			goto if_branch;
		else
			goto else_branch;
	    }
	    if_branch:
	    {
		sum2 = p2 + 1 after 1;	// [2] intended after-after collision
		pro1 = p2 * 7 piped 2;	// [4] intended piped-piped collision
		xxxx = p1 * p2 piped 1;	// [6] intended piped-after collision
		WARN2 = p2 * 2 after 3;	// [8] WARNING EXPECTED!
		WARN3 = p2 + 2 piped 3;	// [9] WARNING EXPECTED!
		goto if_end;
	    }
	    else_branch:
	    {
		sum2 = p2 + 1 after 1;	// [2] intended after-after collision
		pro1 = p2 * 8 piped 2;	// [4] intended piped-piped collision
		xxxx = p1 + p2 after 1;	// [6] intended piped-after collision
		WARN2 = p2 * 3 piped 3;	// [8] WARNING EXPECTED!
		WARN3 = p2 + 3 after 3;	// [9] WARNING EXPECTED!
		goto if_end;
	    }
	    if_end:
	    {
		goto S1;
	    }
	    S1:
	    {
		L_S1_0: i = 0;
		pipe_over_loop = p1 * p2 piped 5;
		goto S2;
	    }
	    S2:
	    {
		i++;
		L_S2_0: status = i < 3;
		if (status)
		{
		    goto S2;
		}
		else 
		{
		    goto S3;
		}
	    }
	    S3:
	    {
		if (p1 > 42)
			if (p2 < 42)
			{	sum1 = p2 * 2 after 2;
				sum2 = p1 - p2 piped 3;
			}
			else
				sum1 = p2 * 2.5 after 2;
		else
		    {	sum1 = p1 * 3 after 2; }
		goto S4;
	    }
	    S4:
	    {
		WARN5 = 111 piped 6;	// [12] WARNING EXPECTED!
		goto S5;
	    }
	    S5:
	    {
		goto S6;
	    }
	    S6:
	    {
		WARN6 = 42 after 2;	// [11] WARNING EXPECTED!
		goto S7;
	    }
	    S7:
	    {
		if (false)
			goto S8;
		else
			break;		// [11]+[12] WARNING EXPECTED!
	    }
	    S8:
	    {
		bool	local;
		bit[8]	ERROR2;

		local = p1 > p2;
		if (local)
		    {
//			ERROR1 = 5 after 1;	// [13] ERROR EXPECTED!
			goto S9;
		    }
		else
		    {
//			ERROR1 = 6 after 1;	// [13] ERROR EXPECTED!
			goto S7;
		    }
//		ERROR2 = 7 piped 3;		// [14] ERROR EXPECTED!
	    }
	    S9:
	    {
		break;
	    }
	    S10:
	    {
		switch(p2)
		{
		    case 0:  { p3 = p1 * p2 after 3; goto S11;
			       break; }
		    case 1:  { p3 = p1 + p2 after 3; goto S12;
			       break; }
		    case 2:  { p3 = p1 - p2 piped 2; goto S13;
			       break; }
		    default: { p3 = p1 / p2 piped 2;
			       break; }
		}
	    }
	    S11:
	    {
		goto S12;
	    }
	    S12:
	    {
		goto S13;
	    }
	    S13:
	    {
		// stay here forever
	    }
	    S_never_used:
	    {
		if (p1)
			{ p3 = -p1 piped 7; }
		else
		   { switch(p2)
			{ case 42: { p3 = ~p1 after 1; break; }
			}
		    }
	    }
	}
    }
};

behavior Main
{
    bit[8]	a, b, c;
    Fsmd	f0(a, b, c);

    int main(void)
    {
	f0;
	return(0);
    }
};
