// i_producer.sc: producer interface to token channel
// (a producer thread sends a number of tokens to a consumer thread)
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 02/12/02 RD	applied naming convention, integrated with distribution
// 02/06/02 RD	initial version (based on generalized handshake.sc)
//
//
// interface rules:
//
// - producer interface to a token channel as known from Petri nets
// - each connected thread acts as a producer
// - a producer calls produce(n) to produce n tokens
// - a call to produce() will produce the given number of tokens and
//   immediately return


interface i_producer
{
    void produce(unsigned long n);
};


// EOF i_producer.sc
