// barrier.sc: example for use of c_barrier
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 02/13/02 RD	initial version (based on barrier_test.sc)


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <sim.sh>

import "c_barrier";	// import the standard channel


int Rnd(int Range)		// random number in range [0...Range-1]
{
    return((int)(drand48() * (double)Range));
}


behavior Thread(		// thread to use the barrier
    i_barrier Barrier,
    in int    ID)
{
    void Sync(void)
    {
	printf("Time%4s: Thread %d blocking on barrier.\n",
		time2str(now()), ID);
	Barrier.barrier();
	printf("Time%4s: Thread %d resuming.\n",
		time2str(now()), ID);
    }

    void Sleep(void)
    {
	int Duration;

	Duration = Rnd(10);
	printf("Time%4s: Thread %d going to sleep for %d time units.\n",
		time2str(now()), ID, Duration);
	if (Duration)
	    waitfor(Duration);
    }

    void main(void)
    {
	int i;

	for(i=0; i<10; i++)
	{
	    Sync();
	    Sleep();
	}
    }
};


behavior Main			// let 5 threads be synchronized by the barrier
{
    c_barrier Barrier(5ul);
    Thread    t1(Barrier, 1),
              t2(Barrier, 2),
              t3(Barrier, 3),
              t4(Barrier, 4),
              t5(Barrier, 5);

    int main(void)
    {
	printf("Time%4s: barrier: Starting...\n",
		time2str(now()));
	par {	t1.main();
		t2.main();
		t3.main();
		t4.main();
		t5.main();
		}
	printf("Time%4s: barrier: Done.\n",
		time2str(now()));
	return 0;
    }
};


// EOF barrier.sc
