


Misc. Reference Manual Pages                              scrc(l)



NNNNAAAAMMMMEEEE
     scrc - SpecC Reference Compiler

SSSSYYYYNNNNOOOOPPPPSSSSIIIISSSS
     ssssccccrrrrcccc -_h

     ssssccccrrrrcccc _d_e_s_i_g_n [ _c_o_m_m_a_n_d ] [ _o_p_t_i_o_n_s ]

DDDDEEEESSSSCCCCRRRRIIIIPPPPTTTTIIIIOOOONNNN
     ssssccccrrrrcccc is the compiler for the SpecC language.  The main  pur-
     pose  of  ssssccccrrrrcccc  is to compile a SpecC source program into an
     executable program for simulation. Furthermore, ssssccccrrrrcccc  serves
     as a general tool to translate SpecC code from various input
     to various output formats which include SpecC  source  text,
     or compiler intermediate files.

     Using the first command syntax  as  shown  in  the  synopsis
     above,  a  brief  usage information and the compiler version
     are printed to standard output and the program exits.  Using
     the second command syntax, the specified _d_e_s_i_g_n is compiled.
     By default, ssssccccrrrrcccc reads a SpecC source file, performs prepro-
     cessing  and  builds  the internal data structure. Then, C++
     code is generated, compiled and linked  into  an  executable
     file  to be used for simulation.  However, the subtasks per-
     formed by ssssccccrrrrcccc are controlled by the given _c_o_m_m_a_n_d so  that,
     for  example, only partial compilation is performed with the
     specified _d_e_s_i_g_n.

     On successful completion, the exit value 0 is returned.   In
     case of errors during processing, an error code with a brief
     diagnostic message is written to standard error and the pro-
     gram execution is aborted with the exit value 10.

     For preprocessing and C++ compilation, ssssccccrrrrcccc  relies  on  the
     availability  of  an  external  C++  compiler  which is used
     automatically in the background. By default,  the  GNU  com-
     piler ggggcccccccc////gggg++++++++ is used.

AAAARRRRGGGGUUUUMMMMEEEENNNNTTTTSSSS
     _d_e_s_i_g_n
          specifies the name of the design; by default, this name
          is  used as base name for the input file and all output
          files;

CCCCOOOOMMMMMMMMAAAANNNNDDDD
     The _c_o_m_m_a_n_d has the format - _s_u_f_f_i_x_1 2 _s_u_f_f_i_x_2,  where  _s_u_f_-
     _f_i_x_1  and  _s_u_f_f_i_x_2  specify the format of the main input and
     output file, respectively.  This command  also  implies  the
     compilation  steps being performed.  By default, the command
     -sc2out is used which specifies reading a SpecC source  file
     (e.g.  design.sc)  and  generating  an executable file (e.g.
     a.out) for  simulation.  All  necessary  intermediate  files



SunOS 5.8          Last change: June 24, 2004                   1






Misc. Reference Manual Pages                              scrc(l)



     (e.g.  design.cc, design.o) are generated automatically.

     Legal command suffixes are:

     _s_c   SpecC source file (default:  _d_e_s_i_g_n._s_c)

     _s_i   preprocessed SpecC source file (default:  _d_e_s_i_g_n._s_i)

     _c_c   C++ simulation source file (default:  _d_e_s_i_g_n._c_c)

     _h    C++ simulation header file (default:  _d_e_s_i_g_n._h)

     _c_c_h  both, C++ simulation source file and  C++  header  file
          (default:  _d_e_s_i_g_n._c_c and _d_e_s_i_g_n._h)

     _o    linker object file (default:  _d_e_s_i_g_n._o)

     _o_u_t  executable file for simulation (default:  _d_e_s_i_g_n)

OOOOPPPPTTTTIIIIOOOONNNNSSSS
     -_v | -_v_v | -_v_v_v
          increase the verbosity level so  that  all  tasks  per-
          formed  are  logged  to  standard  error  (default:  be
          silent); at level 1, informative messages for each task
          performed are displayed; at level 2, additionally input
          and output file names are  listed;  at  level  3,  very
          detailed   information  about  each  executed  task  is
          printed;

     -_w | -_w_w | -_w_w_w
          increase the warning level so that warning messages are
          enabled  (default:  warnings are disabled); four levels
          are supported  ranging  from  only  important  warnings
          (level  1)  to  pedantic  warnings  (level 4); for most
          cases, warning level 2 is recommended (-ww);

     -_g   enable  debugging  of  the  generated  simulation  code
          (default:  no  debugging  code);  this  option disables
          optimization;

     -_O   enable optimization of the  generated  simulation  code
          (default: no optimization); this option disables debug-
          ging;

     -_s_l  suppress source line information  (preprocessor  direc-
          tives)   when  generating  SpecC  or  C++  source  code
          (default: include source line directives);

     -_s_n  suppress all annotations when generating  SpecC  source
          code (default: include annotations);

     -_s_t _t_a_b_u_l_a_t_o_r _s_t_e_p_p_i_n_g



SunOS 5.8          Last change: June 24, 2004                   2






Misc. Reference Manual Pages                              scrc(l)



          set the tabulator stepping for SpecC/C++  code  genera-
          tion;  this  setting  is  used  for code indentation; a
          value of 0 will disable the  indentation  of  the  gen-
          erated code (default: 4);

     -_s_T _s_y_s_t_e_m _t_a_b_u_l_a_t_o_r _s_t_e_p_p_i_n_g
          set the system tabulator stepping  (\t)  for  SpecC/C++
          code  generation;  if  set, tab characters will be used
          for indentation; if a value of  0  is  specified,  only
          spaces will be used for indentation (default: 8);

     -_s_w _l_i_n_e _w_r_a_p_p_i_n_g
          set the column for line wrapping; in  code  generation,
          any  line  longer  than  this  value is subject to line
          wrapping; if a value of 0 is specified, no  line  wrap-
          ping will be performed (default: 70);

     -_i _i_n_p_u_t _f_i_l_e
          specify the name of the input file explicitly (default:
          _d_e_s_i_g_n._s_u_f_f_i_x_1);  the  name  '-' can be used to specify
          reading from standard input;

     -_o _o_u_t_p_u_t _f_i_l_e
          specify the name of the final  output  file  explicitly
          (default:  _d_e_s_i_g_n._s_u_f_f_i_x_2); the name '-' can be used to
          specify writing to standard output;

     -_D   do not define any  standard  macros;  by  default,  the
          macro  __SPECC__ is defined automatically (it is set to
          1); furthermore, implementation dependent macros may be
          defined;  this  option suppresses the definition of all
          these macros;

     -_D_m_a_c_r_o_d_e_f
          define the preprocessor macro _m_a_c_r_o_d_e_f to be passed  to
          the preprocessor;

     -_U   do not undefine any macros; by default, few macros  are
          undefined  automatically (in order to allow C/C++ stan-
          dard header files to be used); this option is implemen-
          tation dependent;

     -_U_u_n_d_e_f
          undefine the preprocessor macro  _u_n_d_e_f  which  will  be
          passed  to  the  preprocessor  as  being undefined; the
          macro _u_n_d_e_f will be undefined after the  definition  of
          all  command-line  macros;  this  allows to selectively
          suppress macros from being defined in the preprocessing
          stage;

     -_I   clear the standard include path; by default, the  stan-
          dard include path consists of the directory $SPECC/inc;



SunOS 5.8          Last change: June 24, 2004                   3






Misc. Reference Manual Pages                              scrc(l)



          this option suppresses the default include path;

     -_I_d_i_r
          append _d_i_r to the include  path  (extend  the  list  of
          directories to be searched for including source files);
          include directories are searched in the order of  their
          specification;  unless  suppressed  by  option  -I, the
          standard include path is automatically appended to this
          list; by default, only the standard include directories
          are searched;

     -_L   clear the standard library path; by default, the  stan-
          dard library path consists of the directory $SPECC/lib;
          this option suppresses the default library path;

     -_L_d_i_r
          append _d_i_r to the library  path  (extend  the  list  of
          directories  to  be searched for linker libraries); the
          library path is searched in the specified order; unless
          suppressed  by  option -L, the standard library path is
          automatically appended to this list; by  default,  only
          the standard library path is searched;

     -_l   when linking, do not use any  standard  libraries;  the
          default  libraries  are displayed when calling the com-
          piler with the -h  option;  the  -l  option  suppresses
          linking against theses standard libraries;

     -_l_l_i_b
          pass _l_i_b as a library to the linker so that the execut-
          able is linked against _l_i_b; libraries are linked in the
          specified order; unless suppressed by  option  -l,  the
          standard  libraries  are automatically appended to this
          list; by default, only standard libraries are used;

     -_P   reset the import path; clear the list of directories to
          be  searched  for  importing  files;  by  default,  the
          current directory is searched first,  followed  by  the
          standard  import  directory  $SPECC/import; this option
          suppresses this standard import path;

     -_P_d_i_r
          append _d_i_r to the  import  path  (extend  the  list  of
          directories to be searched for importing files); import
          directories are searched in the order of their specifi-
          cation;  unless  suppressed  by option -P, the standard
          search path is automatically appended to this list;  by
          default, only the standard import path is searched;

     -_x_p_p _p_r_e_p_r_o_c_e_s_s_o_r__c_a_l_l
          redefine the command to  be  used  for  calling  the  C
          preprocessor  (default:  "g++ -E -x c %p %i -o %o"); in



SunOS 5.8          Last change: June 24, 2004                   4






Misc. Reference Manual Pages                              scrc(l)



          the specified string, every occurence  of  %p  will  be
          replaced with a preprocessor option; additional options
          will be appended; also, %i  and  %o  will  be  replaced
          automatically   with   the   actual  input  and  output
          filename, respectively;

     -_x_c_c _c_o_m_p_i_l_e_r__c_a_l_l
          redefine the command to be used for calling  the  C/C++
          compiler (default: "g++ -c %c %i -o %o"); in the speci-
          fied string, every occurence of  %c  will  be  replaced
          with  a  compiler  option;  additional  options will be
          appended; also, %i and %o will  be  replaced  automati-
          cally  with  the  actual  input  and  output  filename,
          respectively;

     -_x_l_d _l_i_n_k_e_r__c_a_l_l
          redefine the command to be used for calling the  linker
          (default:  "g++ %i -o %o %l"); in the specified string,
          every occurence of %l will be replaced  with  a  linker
          option;  additional  options will be appended; also, %i
          and %o will be replaced automatically with  the  actual
          input and output filename, respectively;

     -_x_p _p_r_e_p_r_o_c_e_s_s_o_r__o_p_t_i_o_n
          pass an option directly to the C/C++ preprocessor;  for
          every  %p  in  the  preprocessor  call  (see above), an
          option has to be specified (default: none);

     -_x_c _c_o_m_p_i_l_e_r__o_p_t_i_o_n
          pass an option directly  to  the  C/C++  compiler;  for
          every  %c  in  the compiler call (see above), an option
          has to be specified (default: none);

     -_x_l _l_i_n_k_e_r__o_p_t_i_o_n
          pass an option directly to the linker; for every %l  in
          the linker call (see above), an option has to be speci-
          fied (default: none);

EEEENNNNVVVVIIIIRRRROOOONNNNMMMMEEEENNNNTTTT
     _S_P_E_C_C
          is used to determine the installation directory of  the
          SpecC  environment  where  SpecC standard include files
          (directory $SPECC/inc),  SpecC  standard  import  files
          (directory  $SPECC/import),  and SpecC system libraries
          (directory $SPECC/lib) are located.

VVVVEEEERRRRSSSSIIIIOOOONNNN
     The SpecC reference compiler ssssccccrrrrcccc is version 2.0.

AAAAUUUUTTTTHHHHOOOORRRR
     Rainer Doemer <doemer@cecs.uci.edu>




SunOS 5.8          Last change: June 24, 2004                   5






Misc. Reference Manual Pages                              scrc(l)



CCCCOOOOPPPPYYYYRRRRIIIIGGGGHHHHTTTT
     (c) 1997-2004 CECS, University of California, Irvine

SSSSEEEEEEEE AAAALLLLSSSSOOOO
     ggggcccccccc(1), gggg++++++++(1),

BBBBUUUUGGGGSSSS,,,, LLLLIIIIMMMMIIIITTTTAAAATTTTIIIIOOOONNNNSSSS
     Variables of enumerator type cannot be  initialized  at  the
     time  of  their  declaration.  The  SpecC  compiler issues a
     (false) error message in  this  case.   As  a  simple  work-
     around,  however, enumerator variables can be initialized by
     use of standard assignment statements at  the  beginning  of
     their lifetimes.










































SunOS 5.8          Last change: June 24, 2004                   6



