// typed_double_handshake.sc: example for use of c_typed_double_handshake
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 04/25/03 RD	adjusted code to new receiver interface in channel library
// 02/19/02 RD	initial version (based on typed_double_handshake_test.sc)


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <sim.sh>


import "c_packet_double_handshake";	// import INSTANTIATED standard channel
//import "c_packet_double_handshake_dbg"; // use this to debug the channel!


#define N	10		// number of handshake transactions


int Rnd(int Range)		// random number in range [0...Range-1]
{
    return((int)(drand48() * (double)Range));
}


behavior Sender(		// the sender behavior
    i_packet_sender DoubleHandshake)
{
    void SendData(int s)
    {
	struct packet Data;
	int           i;

	printf("Time%4s: Sender sending data %d.\n",
		time2str(now()), s);
	Data.i = s;
	Data.b = s % 2;
	Data.c = s;
	Data.f = s / 10;
	Data.v = s @ s[9:0];
	for(i=0; i<10; i++)
	{
	    Data.a[i] = s;
	}
	DoubleHandshake.send(Data);
    }

    void Sleep(void)
    {
	int Duration;

	printf("Time%4s: Sender done, ",
		time2str(now()));
	Duration = Rnd(3);
	printf("going to sleep for %d time units.\n", Duration);
	if (Duration)
	    waitfor(Duration);
    }

    void main(void)
    {
	int s;

	for(s=1; s<=N; s++)
	{
	    SendData(s);
	    Sleep();
	}
    }
};


behavior Receiver(		// the receiver behavior
    i_packet_receiver DoubleHandshake)
{
    void ReceiveData(int r)
    {
	struct packet Data;
	int           i;

	printf("Time%4s: Receiver receiving data %d.\n",
		time2str(now()), r);
	DoubleHandshake.receive(&Data);
	assert(Data.b == Data.i % 2);
	assert(Data.c == Data.i);
	assert(Data.f == Data.i / 10);
	assert(Data.v == Data.i @ Data.i[9:0]);
	for(i=0; i<10; i++)
	{
	    assert(Data.a[i] == Data.i);
	}
    }

    void Sleep(void)
    {
	int Duration;

	printf("Time%4s: Receiver done, ",
		time2str(now()));
	Duration = Rnd(3);
	printf("going to sleep for %d time units.\n", Duration);
	if (Duration)
	    waitfor(Duration);
    }

    void main(void)
    {
	int r;

	for(r=1; r<=N; r++)
	{
	    ReceiveData(r);
	    Sleep();
	}
    }
};


behavior Main	// let the sender send data to the receiver through the channel
{
    c_packet_double_handshake DoubleHandshake;
    Receiver                  r1(DoubleHandshake);
    Sender                    s1(DoubleHandshake);

    int main(void)
    {
	printf("Time%4s: typed_double_handshake: Starting...\n",
		time2str(now()));
	par {	r1.main();
		s1.main();
		}
	printf("Time%4s: typed_double_handshake: Done.\n",
		time2str(now()));
	return 0;
    }
};


// EOF typed_double_handshake.sc
