scrc(l)                                                                scrc(l)



NNAAMMEE
       scrc - SpecC Reference Compiler

SSYYNNOOPPSSIISS
       ssccrrcc _-_h

       ssccrrcc _d_e_s_i_g_n [ _c_o_m_m_a_n_d ] [ _o_p_t_i_o_n_s ]

DDEESSCCRRIIPPTTIIOONN
       ssccrrcc  is the compiler for the SpecC language.  The main purpose of ssccrrcc
       is to compile a SpecC source program into  an  executable  program  for
       simulation.  Furthermore,  ssccrrcc  serves  as a general tool to translate
       SpecC code from various input to various output formats  which  include
       SpecC source text, or compiler intermediate files.

       Using  the first command syntax as shown in the synopsis above, a brief
       usage information and the compiler version are printed to standard out-
       put and the program exits.  Using the second command syntax, the speci-
       fied _d_e_s_i_g_n is compiled. By default, ssccrrcc reads a  SpecC  source  file,
       performs  preprocessing  and  builds the internal data structure. Then,
       C++ code is generated, compiled and linked into an executable  file  to
       be  used  for  simulation.  However, the subtasks performed by ssccrrcc are
       controlled by the given _c_o_m_m_a_n_d so that, for example, only partial com-
       pilation is performed with the specified _d_e_s_i_g_n_.

       On  successful  completion,  the  exit value 0 is returned.  In case of
       errors during processing, an error code with a brief diagnostic message
       is  written to standard error and the program execution is aborted with
       the exit value 10.

       For preprocessing and C++ compilation, ssccrrcc relies on the  availability
       of  an  external  C++ compiler which is used automatically in the back-
       ground. By default, the GNU compiler ggcccc//gg++++ is used.

AARRGGUUMMEENNTTSS
       _d_e_s_i_g_n specifies the name of the design; by default, this name is  used
              as base name for the input file and all output files;

CCOOMMMMAANNDD
       The  _c_o_m_m_a_n_d has the format - _s_u_f_f_i_x_1 2 _s_u_f_f_i_x_2_, where _s_u_f_f_i_x_1 and _s_u_f_-
       _f_i_x_2 specify the format of the main  input  and  output  file,  respec-
       tively.   This  command  also  implies the compilation steps being per-
       formed.  By default, the command -sc2out is used which specifies  read-
       ing  a  SpecC source file (e.g. design.sc) and generating an executable
       file (e.g. a.out) for  simulation.  All  necessary  intermediate  files
       (e.g.  design.cc, design.o) are generated automatically.

       Legal command suffixes are:

       _s_c     SpecC source file (default: _d_e_s_i_g_n_._s_c_)

       _s_i     preprocessed SpecC source file (default: _d_e_s_i_g_n_._s_i_)

       _c_c     C++ simulation source file (default: _d_e_s_i_g_n_._c_c_)

       _h      C++ simulation header file (default: _d_e_s_i_g_n_._h_)

       _c_c_h    both,  C++  simulation source file and C++ header file (default:
              _d_e_s_i_g_n_._c_c and _d_e_s_i_g_n_._h_)

       _o      linker object file (default: _d_e_s_i_g_n_._o_)

       _o_u_t    executable file for simulation (default: _d_e_s_i_g_n_)

OOPPTTIIOONNSS
       _-_v _| _-_v_v _| _-_v_v_v
              increase the verbosity level so that  all  tasks  performed  are
              logged  to  standard  error  (default:  be  silent); at level 1,
              informative messages for each task performed are  displayed;  at
              level 2, additionally input and output file names are listed; at
              level 3, very detailed information about each executed  task  is
              printed;

       _-_w _| _-_w_w _| _-_w_w_w
              increase  the warning level so that warning messages are enabled
              (default: warnings are  disabled);  four  levels  are  supported
              ranging from only important warnings (level 1) to pedantic warn-
              ings (level 4); for most cases, warning level 2  is  recommended
              (-ww);

       _-_g     enable  debugging  of the generated simulation code (default: no
              debugging code); this option disables optimization;

       _-_O     enable optimization of the generated simulation  code  (default:
              no optimization); this option disables debugging;

       _-_s_l    suppress  source line information (preprocessor directives) when
              generating SpecC or C++ source  code  (default:  include  source
              line directives);

       _-_s_n    suppress  all  annotations  when  generating  SpecC  source code
              (default: include annotations);

       _-_s_t _t_a_b_u_l_a_t_o_r _s_t_e_p_p_i_n_g
              set the tabulator stepping for SpecC/C++ code  generation;  this
              setting  is used for code indentation; a value of 0 will disable
              the indentation of the generated code (default: 4);

       _-_s_T _s_y_s_t_e_m _t_a_b_u_l_a_t_o_r _s_t_e_p_p_i_n_g
              set the system tabulator stepping (\t) for SpecC/C++ code gener-
              ation; if set, tab characters will be used for indentation; if a
              value of 0 is specified, only spaces will be used  for  indenta-
              tion (default: 8);

       _-_s_w _l_i_n_e _w_r_a_p_p_i_n_g
              set  the  column for line wrapping; in code generation, any line
              longer than this value is subject to line wrapping; if  a  value
              of  0 is specified, no line wrapping will be performed (default:
              70);

       _-_i _i_n_p_u_t _f_i_l_e
              specify  the  name  of  the  input  file  explicitly   (default:
              _d_e_s_i_g_n_._s_u_f_f_i_x_1_)_;  the  name  '-'  can be used to specify reading
              from standard input;

       _-_o _o_u_t_p_u_t _f_i_l_e
              specify the name of the final output file  explicitly  (default:
              _d_e_s_i_g_n_._s_u_f_f_i_x_2_)_;  the name '-' can be used to specify writing to
              standard output;

       _-_D     do not  define  any  standard  macros;  by  default,  the  macro
              __SPECC__  is  defined  automatically (it is set to 1); further-
              more, implementation  dependent  macros  may  be  defined;  this
              option suppresses the definition of all these macros;

       _-_D_m_a_c_r_o_d_e_f
              define  the preprocessor macro _m_a_c_r_o_d_e_f to be passed to the pre-
              processor;

       _-_U     do not undefine any macros; by default, few macros are undefined
              automatically  (in order to allow C/C++ standard header files to
              be used); this option is implementation dependent;

       _-_U_u_n_d_e_f
              undefine the preprocessor macro _u_n_d_e_f which will  be  passed  to
              the  preprocessor  as  being  undefined; the macro _u_n_d_e_f will be
              undefined after the definition of all command-line macros;  this
              allows  to selectively suppress macros from being defined in the
              preprocessing stage;

       _-_I     clear the  standard  include  path;  by  default,  the  standard
              include  path  consists of the directory $SPECC/inc; this option
              suppresses the default include path;

       _-_I_d_i_r  append _d_i_r to the include path (extend the list  of  directories
              to  be searched for including source files); include directories
              are searched in the order of their  specification;  unless  sup-
              pressed by option -I, the standard include path is automatically
              appended to this list; by default,  only  the  standard  include
              directories are searched;

       _-_L     clear  the  standard  library  path;  by  default,  the standard
              library path consists of the directory $SPECC/lib;  this  option
              suppresses the default library path;

       _-_L_d_i_r  append  _d_i_r  to the library path (extend the list of directories
              to be searched  for  linker  libraries);  the  library  path  is
              searched in the specified order; unless suppressed by option -L,
              the standard library path  is  automatically  appended  to  this
              list; by default, only the standard library path is searched;

       _-_l     when  linking,  do  not  use any standard libraries; the default
              libraries are displayed when calling the compiler  with  the  -h
              option; the -l option suppresses linking against theses standard
              libraries;

       _-_l_l_i_b  pass _l_i_b as a library to the linker so that  the  executable  is
              linked against _l_i_b_; libraries are linked in the specified order;
              unless suppressed by option -l, the standard libraries are auto-
              matically  appended  to  this  list;  by  default, only standard
              libraries are used;

       _-_P     reset the import path; clear  the  list  of  directories  to  be
              searched  for importing files; by default, the current directory
              is searched first, followed by  the  standard  import  directory
              $SPECC/import; this option suppresses this standard import path;

       _-_P_d_i_r  append _d_i_r to the import path (extend the list of directories to
              be   searched  for  importing  files);  import  directories  are
              searched in the order of their specification; unless  suppressed
              by option -P, the standard search path is automatically appended
              to this list; by default,  only  the  standard  import  path  is
              searched;

       _-_x_p_p _p_r_e_p_r_o_c_e_s_s_o_r___c_a_l_l
              redefine  the  command to be used for calling the C preprocessor
              (default: "g++ -E -x c %p %i -o %o"); in the  specified  string,
              every  occurence  of  %p  will  be  replaced with a preprocessor
              option; additional options will be appended;  also,  %i  and  %o
              will  be replaced automatically with the actual input and output
              filename, respectively;

       _-_x_c_c _c_o_m_p_i_l_e_r___c_a_l_l
              redefine the command to be used for calling the  C/C++  compiler
              (default:  "g++ -c %c %i -o %o"); in the specified string, every
              occurence of %c will be replaced with a compiler  option;  addi-
              tional  options  will  be  appended;  also,  %i  and  %o will be
              replaced automatically with the actual input  and  output  file-
              name, respectively;

       _-_x_l_d _l_i_n_k_e_r___c_a_l_l
              redefine the command to be used for calling the linker (default:
              "g++ %i -o %o %l"); in the specified string, every occurence  of
              %l  will  be  replaced  with a linker option; additional options
              will be appended; also, %i and %o will be replaced automatically
              with the actual input and output filename, respectively;

       _-_x_p _p_r_e_p_r_o_c_e_s_s_o_r___o_p_t_i_o_n
              pass  an option directly to the C/C++ preprocessor; for every %p
              in the preprocessor call (see above), an option has to be speci-
              fied (default: none);

       _-_x_c _c_o_m_p_i_l_e_r___o_p_t_i_o_n
              pass  an  option directly to the C/C++ compiler; for every %c in
              the compiler call (see above), an option  has  to  be  specified
              (default: none);

       _-_x_l _l_i_n_k_e_r___o_p_t_i_o_n
              pass  an  option  directly  to  the  linker; for every %l in the
              linker call (see above), an option has to be specified (default:
              none);

EENNVVIIRROONNMMEENNTT
       _S_P_E_C_C  is  used  to  determine  the installation directory of the SpecC
              environment  where  SpecC  standard  include  files   (directory
              $SPECC/inc),    SpecC    standard    import   files   (directory
              $SPECC/import),   and   SpecC   system   libraries    (directory
              $SPECC/lib) are located.

VVEERRSSIIOONN
       The SpecC reference compiler ssccrrcc is version 2.0.

AAUUTTHHOORR
       Rainer Doemer <doemer@cecs.uci.edu>

CCOOPPYYRRIIGGHHTT
       (c) 1997-2004 CECS, University of California, Irvine

SSEEEE AALLSSOO
       ggcccc(1), gg++++(1),

BBUUGGSS,, LLIIMMIITTAATTIIOONNSS
       Variables of enumerator type cannot be initialized at the time of their
       declaration. The SpecC compiler issues a (false) error message in  this
       case.   As  a  simple work-around, however, enumerator variables can be
       initialized by use of standard assignment statements at  the  beginning
       of their lifetimes.



                                 June 24, 2004                         scrc(l)
