// ============================================================================
// longlong.h: "long long" data type support
// ============================================================================
// 
// 04/08/02 <doemer>	added typedefs _LONGLONG and _ULONGLONG
// 11/28/01 <gerstl>	Removed ambiguities, move more casting into scc
// 05/24/01 <gerstl>	Initial version
//
// ----------------------------------------------------------------------------
#ifndef __LONGLONG
#define __LONGLONG
/* ------------------------------------------------------------------------- */
/* Native (built-in) long long data type */
#include <limits.h>
// Native long long version of library
#undef HAVE_LLONG
#define HAVE_LLONG
// Provide constants
#ifndef LONG_LONG_MAX
#ifdef LLONG_MAX
#define LONG_LONG_MAX LLONG_MAX // SOLARIS et al.
#elif defined(QUAD_MAX)
#define LONG_LONG_MAX QUAD_MAX // NETBSD
#else
#define LONG_LONG_MAX 0x7fffffffffffffffLL
#endif
#endif
#ifndef ULONG_LONG_MAX
#ifdef ULLONG_MAX
#define ULONG_LONG_MAX ULLONG_MAX // SOLARIS et al.
#elif defined(UQUAD_MAX)
#define ULONG_LONG_MAX UQUAD_MAX // NETBSD
#else
#define ULONG_LONG_MAX 0xffffffffffffffffULL
#endif
#endif
#ifndef LLONG_MAX
#define LLONG_MAX LONG_LONG_MAX
#endif
#ifndef ULLONG_MAX
#define ULLONG_MAX ULONG_LONG_MAX
#endif
/* --- Provide typedefs --- */
typedef long long _LONGLONG;
typedef unsigned long long _ULONGLONG;
/* ---  Global functions --- */
extern "C" {
// conversion of long long to string (see sim.sh)  
char *ll2str(unsigned int base, char *endptr, long long ll);
char *ull2str(unsigned int base, char *endptr, unsigned long long ull);
// conversion of string to long long (see sim.sh)
long long str2ll(unsigned int base, const char* str);
unsigned long long str2ull(unsigned int base, const char* str);
}
/* ------------------------------------------------------------------------- */
/* Non-native long long data type support */
// Disable native long long on Solaris
// Non-native long long version of library    
// Provide constants
/* --- Forward declaration of signed/unsigned class --- */
/* --- Provide typedefs --- */
/* --- Global functions --- */
// conversion of long long to string (see sim.sh)  
// conversion of string to long long (see sim.sh)
/* ------------------------------------------------------------------------- */
/* Class for type "long long", signed/unsigned */
/* --- Base class, long long representation --- */
  // long long representation
  // Test
  // Explicit conversions
/* --- Working long long class --- */
  // Initialization / Construction
  // Assignement
  // Arithmetic
  // Increment & decrement
  // Logic
  // Shifting
  // Comparison
  // negation
  // string assignement
  // multiplication helper
  // division helpers
/* --- signed/unsigned long long --- */
  // Initialization / Construction
  // Type-true assignments
  // Type-true arithmetic
  // Type-true increment & decrement
  // Type-true logic
  // Type-true shift
/* --- Shadow class for long long inside a union --- */
  // No constructors allowed inside a union!
  // Cast to real, working _longlong class
  // assignements
  // arithmetic
  // increment & decrement
  // logic
  // shift
/* ------------------------------------------------------------------------- */
/* External operators */
/* --- Addition --- */
// signed
// unsigned
/* --- Subtraction --- */
// signed
// unsigned
/* --- Multiplication --- */
// signed
// unsigned
/* --- Division --- */
// signed
// unsigned
/* --- Modulo */
// signed
// unsigned
/* --- And */
// signed
// unsigned
/* --- Or */
// signed
// unsigned
/* --- Xor */
// signed
// unsigned
/* --- Shift */
// signed
// unsigned
/* --- Comparison */
// signed
// unsigned
/* ------------------------------------------------------------------------- */
/* Deferred inline operators */
/* --- Arithmetic --- */
// Addition
// Subtraction
// Multiplication
// Division
                         // clear any part of remainder in upper chunk
// Modulo
                         // clear any part of quotient left in upper chunk
// Type-true division
  // Signed division?
    // Make operands positive
    // Divide
    // Adjust result
// Type-true modulo
  // Signed division?
    // Make operands positive
    // Divide
    // Adjust result
// Negation
// Type-true negation
// Type-true identity
/* --- Logic --- */
// And
// Or
// Xor
// Inversion
/* --- Shifting --- */
// Left shift
// Right shift
/* --- Increment & decrement --- */
// Prefix
// Postfix
#endif
