// queue.sc: example for use of c_queue
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 02/15/02 RD	initial version (based on queue_test2.sc)


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <sim.sh>


import "c_queue";	// import the standard channel


const unsigned long SIZE = 200;	// number of bytes available in the queue

const long N             = 100;	// number of read and write transactions
				// (less than queue size!)


int Rnd(int Range)		// random number in range [0...Range-1]
{
    return((int)(drand48() * (double)Range));
}


behavior Sender(		// the sender behavior
    i_sender Queue)
{
    void SendData(int s)
    {
	char Data[SIZE];
	int  i;

	printf("Time%4s: Sender storing %d bytes.\n",
		time2str(now()), s);
	for(i=0; i<s; i++)
	{
	    Data[i] = (char) s;
	}
	Queue.send(Data, s);
    }

    void Sleep(void)
    {
	int Duration;

	printf("Time%4s: Sender done, ",
		time2str(now()));
	Duration = Rnd(10);
	printf("going to sleep for %d time units.\n", Duration);
	if (Duration)
	    waitfor(Duration);
    }

    void main(void)
    {
	int s;

	for(s=1; s<=N; s++)
	{
	    SendData(s);
	    Sleep();
	}
    }
};


behavior Receiver(		// the receiver behavior
    i_receiver Queue)
{
    void ReceiveData(int r)
    {
	char Data[SIZE];
	int  i;

	printf("Time%4s: Receiver loading %d bytes.\n",
		time2str(now()), r);
	Queue.receive(Data, r);
	for(i=0; i<r; i++)
	{
	    assert(Data[i] == (char) r);
	}
    }

    void Sleep(void)
    {
	int Duration;

	printf("Time%4s: Receiver done, ",
		time2str(now()));
	Duration = Rnd(10);
	printf("going to sleep for %d time units.\n", Duration);
	if (Duration)
	    waitfor(Duration);
    }

    void main(void)
    {
	int r;

	for(r=1; r<=N; r++)
	{
	    ReceiveData(r);
	    Sleep();
	}
    }
};


behavior Main	// let the sender send data to the receiver through the queue
{
    c_queue   Queue((SIZE));
    Receiver  r1(Queue);
    Sender    s1(Queue);

    int main(void)
    {
	printf("Time%4s: queue: Starting...\n",
		time2str(now()));
	par {	r1.main();
		s1.main();
		}
	printf("Time%4s: queue: Done.\n",
		time2str(now()));
	return 0;
    }
};


// EOF queue.sc
