scrc(l)                                                                scrc(l)



[1mNAME[0m
       scrc - SpecC Reference Compiler

[1mSYNOPSIS[0m
       [1mscrc [4m[22m-h[0m

       [1mscrc [4m[22mdesign[24m [ [4mcommand[24m ] [ [4moptions[24m ]

[1mDESCRIPTION[0m
       [1mscrc  [22mis the compiler for the SpecC language.  The main purpose of [1mscrc[0m
       is to compile a SpecC source program into  an  executable  program  for
       simulation.  Furthermore,  [1mscrc  [22mserves  as a general tool to translate
       SpecC code from various input to various output formats  which  include
       SpecC source text, or compiler intermediate files.

       Using  the first command syntax as shown in the synopsis above, a brief
       usage information and the compiler version are printed to standard out-
       put and the program exits.  Using the second command syntax, the speci-
       fied [4mdesign[24m is compiled. By default, [1mscrc [22mreads a  SpecC  source  file,
       performs  preprocessing  and  builds the internal data structure. Then,
       C++ code is generated, compiled and linked into an executable  file  to
       be  used  for  simulation.  However, the subtasks performed by [1mscrc [22mare
       controlled by the given [4mcommand[24m so that, for example, only partial com-
       pilation is performed with the specified [4mdesign.[0m

       On  successful  completion,  the  exit value 0 is returned.  In case of
       errors during processing, an error code with a brief diagnostic message
       is  written to standard error and the program execution is aborted with
       the exit value 10.

       For preprocessing and C++ compilation, [1mscrc [22mrelies on the  availability
       of  an  external  C++ compiler which is used automatically in the back-
       ground. By default, the GNU compiler [1mgcc/g++ [22mis used.

[1mARGUMENTS[0m
       [4mdesign[24m specifies the name of the design; by default, this name is  used
              as base name for the input file and all output files;

[1mCOMMAND[0m
       The  [4mcommand[24m has the format - [4msuffix1[24m 2 [4msuffix2,[24m where [4msuffix1[24m and [4msuf-[0m
       [4mfix2[24m specify the format of the main  input  and  output  file,  respec-
       tively.   This  command  also  implies the compilation steps being per-
       formed.  By default, the command -sc2out is used which specifies  read-
       ing  a  SpecC source file (e.g. design.sc) and generating an executable
       file (e.g. a.out) for  simulation.  All  necessary  intermediate  files
       (e.g.  design.cc, design.o) are generated automatically.

       Legal command suffixes are:

       [4msc[24m     SpecC source file (default: [4mdesign.sc)[0m

       [4msi[24m     preprocessed SpecC source file (default: [4mdesign.si)[0m

       [4mcc[24m     C++ simulation source file (default: [4mdesign.cc)[0m

       [4mh[24m      C++ simulation header file (default: [4mdesign.h)[0m

       [4mcch[24m    both,  C++  simulation source file and C++ header file (default:
              [4mdesign.cc[24m and [4mdesign.h)[0m

       [4mo[24m      linker object file (default: [4mdesign.o)[0m

       [4mout[24m    executable file for simulation (default: [4mdesign)[0m

[1mOPTIONS[0m
       [4m-v[24m [4m|[24m [4m-vv[24m [4m|[24m [4m-vvv[0m
              increase the verbosity level so that  all  tasks  performed  are
              logged  to  standard  error  (default:  be  silent); at level 1,
              informative messages for each task performed are  displayed;  at
              level 2, additionally input and output file names are listed; at
              level 3, very detailed information about each executed  task  is
              printed;

       [4m-w[24m [4m|[24m [4m-ww[24m [4m|[24m [4m-www[0m
              increase  the warning level so that warning messages are enabled
              (default: warnings are  disabled);  four  levels  are  supported
              ranging from only important warnings (level 1) to pedantic warn-
              ings (level 4); for most cases, warning level 2  is  recommended
              (-ww);

       [4m-g[24m     enable  debugging  of the generated simulation code (default: no
              debugging code); this option disables optimization;

       [4m-O[24m     enable optimization of the generated simulation  code  (default:
              no optimization); this option disables debugging;

       [4m-sl[24m    suppress  source line information (preprocessor directives) when
              generating SpecC or C++ source  code  (default:  include  source
              line directives);

       [4m-sn[24m    suppress  all  annotations  when  generating  SpecC  source code
              (default: include annotations);

       [4m-st[24m [4mtabulator[24m [4mstepping[0m
              set the tabulator stepping for SpecC/C++ code  generation;  this
              setting  is used for code indentation; a value of 0 will disable
              the indentation of the generated code (default: 4);

       [4m-sT[24m [4msystem[24m [4mtabulator[24m [4mstepping[0m
              set the system tabulator stepping (\t) for SpecC/C++ code gener-
              ation; if set, tab characters will be used for indentation; if a
              value of 0 is specified, only spaces will be used  for  indenta-
              tion (default: 8);

       [4m-sw[24m [4mline[24m [4mwrapping[0m
              set  the  column for line wrapping; in code generation, any line
              longer than this value is subject to line wrapping; if  a  value
              of  0 is specified, no line wrapping will be performed (default:
              70);

       [4m-i[24m [4minput[24m [4mfile[0m
              specify  the  name  of  the  input  file  explicitly   (default:
              [4mdesign.suffix1);[24m  the  name  '-'  can be used to specify reading
              from standard input;

       [4m-o[24m [4moutput[24m [4mfile[0m
              specify the name of the final output file  explicitly  (default:
              [4mdesign.suffix2);[24m  the name '-' can be used to specify writing to
              standard output;

       [4m-D[24m     do not  define  any  standard  macros;  by  default,  the  macro
              __SPECC__  is  defined  automatically (it is set to 1); further-
              more, implementation  dependent  macros  may  be  defined;  this
              option suppresses the definition of all these macros;

       [4m-Dmacrodef[0m
              define  the preprocessor macro [4mmacrodef[24m to be passed to the pre-
              processor;

       [4m-U[24m     do not undefine any macros; by default, few macros are undefined
              automatically  (in order to allow C/C++ standard header files to
              be used); this option is implementation dependent;

       [4m-Uundef[0m
              undefine the preprocessor macro [4mundef[24m which will  be  passed  to
              the  preprocessor  as  being  undefined; the macro [4mundef[24m will be
              undefined after the definition of all command-line macros;  this
              allows  to selectively suppress macros from being defined in the
              preprocessing stage;

       [4m-I[24m     clear the  standard  include  path;  by  default,  the  standard
              include  path  consists of the directory $SPECC/inc; this option
              suppresses the default include path;

       [4m-Idir[24m  append [4mdir[24m to the include path (extend the list  of  directories
              to  be searched for including source files); include directories
              are searched in the order of their  specification;  unless  sup-
              pressed by option -I, the standard include path is automatically
              appended to this list; by default,  only  the  standard  include
              directories are searched;

       [4m-L[24m     clear  the  standard  library  path;  by  default,  the standard
              library path consists of the directory $SPECC/lib;  this  option
              suppresses the default library path;

       [4m-Ldir[24m  append  [4mdir[24m  to the library path (extend the list of directories
              to be searched  for  linker  libraries);  the  library  path  is
              searched in the specified order; unless suppressed by option -L,
              the standard library path  is  automatically  appended  to  this
              list; by default, only the standard library path is searched;

       [4m-l[24m     when  linking,  do  not  use any standard libraries; the default
              libraries are displayed when calling the compiler  with  the  -h
              option; the -l option suppresses linking against theses standard
              libraries;

       [4m-llib[24m  pass [4mlib[24m as a library to the linker so that  the  executable  is
              linked against [4mlib;[24m libraries are linked in the specified order;
              unless suppressed by option -l, the standard libraries are auto-
              matically  appended  to  this  list;  by  default, only standard
              libraries are used;

       [4m-P[24m     reset the import path; clear  the  list  of  directories  to  be
              searched  for importing files; by default, the current directory
              is searched first, followed by  the  standard  import  directory
              $SPECC/import; this option suppresses this standard import path;

       [4m-Pdir[24m  append [4mdir[24m to the import path (extend the list of directories to
              be   searched  for  importing  files);  import  directories  are
              searched in the order of their specification; unless  suppressed
              by option -P, the standard search path is automatically appended
              to this list; by default,  only  the  standard  import  path  is
              searched;

       [4m-xpp[24m [4mpreprocessor_call[0m
              redefine  the  command to be used for calling the C preprocessor
              (default: "g++ -E -x c %p %i -o %o"); in the  specified  string,
              every  occurence  of  %p  will  be  replaced with a preprocessor
              option; additional options will be appended;  also,  %i  and  %o
              will  be replaced automatically with the actual input and output
              filename, respectively;

       [4m-xcc[24m [4mcompiler_call[0m
              redefine the command to be used for calling the  C/C++  compiler
              (default:  "g++ -c %c %i -o %o"); in the specified string, every
              occurence of %c will be replaced with a compiler  option;  addi-
              tional  options  will  be  appended;  also,  %i  and  %o will be
              replaced automatically with the actual input  and  output  file-
              name, respectively;

       [4m-xld[24m [4mlinker_call[0m
              redefine the command to be used for calling the linker (default:
              "g++ %i -o %o %l"); in the specified string, every occurence  of
              %l  will  be  replaced  with a linker option; additional options
              will be appended; also, %i and %o will be replaced automatically
              with the actual input and output filename, respectively;

       [4m-xp[24m [4mpreprocessor_option[0m
              pass  an option directly to the C/C++ preprocessor; for every %p
              in the preprocessor call (see above), an option has to be speci-
              fied (default: none);

       [4m-xc[24m [4mcompiler_option[0m
              pass  an  option directly to the C/C++ compiler; for every %c in
              the compiler call (see above), an option  has  to  be  specified
              (default: none);

       [4m-xl[24m [4mlinker_option[0m
              pass  an  option  directly  to  the  linker; for every %l in the
              linker call (see above), an option has to be specified (default:
              none);

[1mENVIRONMENT[0m
       [4mSPECC[24m  is  used  to  determine  the installation directory of the SpecC
              environment  where  SpecC  standard  include  files   (directory
              $SPECC/inc),    SpecC    standard    import   files   (directory
              $SPECC/import),   and   SpecC   system   libraries    (directory
              $SPECC/lib) are located.

[1mVERSION[0m
       The SpecC reference compiler [1mscrc [22mis version 2.0.

[1mAUTHOR[0m
       Rainer Doemer <doemer@cecs.uci.edu>

[1mCOPYRIGHT[0m
       (c) 1997-2004 CECS, University of California, Irvine

[1mSEE ALSO[0m
       [1mgcc[22m(1), [1mg++[22m(1),

[1mBUGS, LIMITATIONS[0m
       Variables of enumerator type cannot be initialized at the time of their
       declaration. The SpecC compiler issues a (false) error message in  this
       case.   As  a  simple work-around, however, enumerator variables can be
       initialized by use of standard assignment statements at  the  beginning
       of their lifetimes.



                                 June 24, 2004                         scrc(l)
