//////////////////////////////////////////////////////////////////////
// SpecC source code generated by SCRC V2.0
// Design: c_bit64_queue
// File:   c_bit64_queue_dbg.sc
// Time:   Mon Jun 28 10:37:38 2004
//////////////////////////////////////////////////////////////////////

// Note: Line infos are suppressed in this file.

// named user-defined type declarations //////////////////////////////

struct _Bigint;
struct __sFILE;
struct __sbuf;
struct __tm;
struct _atexit;
struct _glue;
struct _on_exit_args;
struct _rand48;
struct _reent;
struct _types_fd_set;
struct itimerspec;
struct timespec;

// struct/union type definitions /////////////////////////////////////

struct _Bigint {
    struct _Bigint *_next;
    int _k;
    int _maxwds;
    int _sign;
    int _wds;
    unsigned long int _x[1];
};

struct __sbuf {
    unsigned char *_base;
    int _size;
};

struct __sFILE {
    unsigned char *_p;
    int _r;
    int _w;
    short int _flags;
    short int _file;
    struct __sbuf _bf;
    int _lbfsize;
    void *_cookie;
    int (*_read)(void *, char *, int);
    int (*_write)(void *, const char *, int);
    long int (*_seek)(void *, long int, int);
    int (*_close)(void *);
    struct __sbuf _ub;
    unsigned char *_up;
    int _ur;
    unsigned char _ubuf[3];
    unsigned char _nbuf[1];
    struct __sbuf _lb;
    int _blksize;
    int _offset;
    struct _reent *_data;
    int _lock;
};

struct __tm {
    int __tm_sec;
    int __tm_min;
    int __tm_hour;
    int __tm_mday;
    int __tm_mon;
    int __tm_year;
    int __tm_wday;
    int __tm_yday;
    int __tm_isdst;
};

struct _on_exit_args {
    void *_fnargs[32];
    unsigned long int _fntypes;
};

struct _atexit {
    struct _atexit *_next;
    int _ind;
    void (*_fns[32])(void);
    struct _on_exit_args _on_exit_args;
};

struct _glue {
    struct _glue *_next;
    int _niobs;
    struct __sFILE *_iobs;
};

struct _rand48 {
    unsigned short int _seed[3];
    unsigned short int _mult[3];
    unsigned short int _add;
};

typedef struct {
    int __count;
    union { unsigned int __wch; unsigned char __wchb[4]; } __value; }
    _mbstate_t;

struct _reent {
    int _errno;
    struct __sFILE *_stdin;
    struct __sFILE *_stdout;
    struct __sFILE *_stderr;
    int _inc;
    char _emergency[25];
    int _current_category;
    const char *_current_locale;
    int __sdidinit;
    void (*__cleanup)(struct _reent *);
    struct _Bigint *_result;
    int _result_k;
    struct _Bigint *_p5s;
    struct _Bigint **_freelist;
    int _cvtlen;
    char *_cvtbuf;
    union { struct { unsigned int _unused_rand; char *_strtok_last; char _asctime_buf[26]; struct __tm _localtime_buf; int _gamma_signgam; unsigned long long int _rand_next; struct _rand48 _r48; _mbstate_t _mblen_state; _mbstate_t _mbtowc_state; _mbstate_t _wctomb_state; char _l64a_buf[8]; char _signal_buf[24]; int _getdate_err; _mbstate_t _mbrlen_state; _mbstate_t _mbrtowc_state; _mbstate_t _mbsrtowcs_state; _mbstate_t _wcrtomb_state; _mbstate_t _wcsrtombs_state; } _reent; struct { unsigned char *_nextf[30]; unsigned int _nmalloc[30]; } _unused; } _new;
    struct _atexit *_atexit;
    struct _atexit _atexit0;
    void (**_sig_func)(int);
    struct _glue __sglue;
    struct __sFILE __sf[3];
};

struct _types_fd_set {
    long int fds_bits[2];
};

struct timespec {
    long int tv_sec;
    long int tv_nsec;
};

struct itimerspec {
    struct timespec it_interval;
    struct timespec it_value;
};

typedef struct {
    int quot;
    int rem; }
    div_t;

typedef struct {
    long int quot;
    long int rem; }
    ldiv_t;

typedef struct {
    long long int quot;
    long long int rem; }
    lldiv_t;

// type synonym definitions //////////////////////////////////////////

typedef long int __off_t;
typedef int __pid_t;
typedef long long int __loff_t;
typedef struct __sFILE FILE;
typedef long int fpos_t;
typedef long int _off_t;
typedef long long int _off64_t;
typedef int _ssize_t;
typedef int _flock_t;
typedef void *_iconv_t;
typedef void *_LOCK_T;
typedef unsigned long int __ULong;
typedef long int _fpos_t;
typedef struct __sFILE __FILE;
typedef short int __int16_t;
typedef unsigned short int __uint16_t;
typedef int __int32_t;
typedef unsigned int __uint32_t;
typedef long long int __int64_t;
typedef unsigned long long int __uint64_t;
typedef unsigned char u_char;
typedef unsigned short int u_short;
typedef unsigned int u_int;
typedef unsigned long int u_long;
typedef unsigned short int ushort;
typedef unsigned int uint;
typedef unsigned long int clock_t;
typedef long int time_t;
typedef long int daddr_t;
typedef char *caddr_t;
typedef unsigned short int ino_t;
typedef short int dev_t;
typedef long int off_t;
typedef unsigned short int uid_t;
typedef unsigned short int gid_t;
typedef int pid_t;
typedef long int key_t;
typedef int ssize_t;
typedef unsigned int mode_t;
typedef unsigned short int nlink_t;
typedef long int fd_mask;
typedef struct _types_fd_set _types_fd_set;
typedef void *__gnuc_va_list;
typedef int ptrdiff_t;
typedef unsigned int size_t;
typedef unsigned short int wchar_t;
typedef unsigned int wint_t;

// interface declarations ////////////////////////////////////////////

interface i_bit64_tranceiver;
interface i_bit64_sender;
interface i_bit64_receiver;

// channel declarations //////////////////////////////////////////////

channel c_bit64_queue(
    in const unsigned long int) implements i_bit64_sender, i_bit64_receiver, i_bit64_tranceiver;

// variable and function declarations ////////////////////////////////

struct __sFILE *tmpfile(void);
char *tmpnam(char *);
int fclose(struct __sFILE *);
int fflush(struct __sFILE *);
struct __sFILE *freopen(const char *, const char *, struct __sFILE *);
void setbuf(struct __sFILE *, char *);
int setvbuf(struct __sFILE *, char *, int, unsigned int);
int fprintf(struct __sFILE *, const char *, ...);
int fscanf(struct __sFILE *, const char *, ...);
int printf(const char *, ...);
int scanf(const char *, ...);
int sscanf(const char *, const char *, ...);
int vfprintf(struct __sFILE *, const char *, void *);
int vprintf(const char *, void *);
int vsprintf(char *, const char *, void *);
int fgetc(struct __sFILE *);
char *fgets(char *, int, struct __sFILE *);
int fputc(int, struct __sFILE *);
int fputs(const char *, struct __sFILE *);
int getc(struct __sFILE *);
int getchar(void);
char *gets(char *);
int putc(int, struct __sFILE *);
int putchar(int);
int puts(const char *);
int ungetc(int, struct __sFILE *);
unsigned int fread(void *, unsigned int, unsigned int, struct __sFILE *);
unsigned int fwrite(const void *, unsigned int, unsigned int, struct __sFILE *);
int fgetpos(struct __sFILE *, long int *);
int fseek(struct __sFILE *, long int, int);
int fsetpos(struct __sFILE *, const long int *);
long int ftell(struct __sFILE *);
void rewind(struct __sFILE *);
void clearerr(struct __sFILE *);
int feof(struct __sFILE *);
int ferror(struct __sFILE *);
void perror(const char *);
struct __sFILE *fopen(const char *, const char *);
int sprintf(char *, const char *, ...);
int remove(const char *);
int rename(const char *, const char *);
int asprintf(char **, const char *, ...);
int fseeko(struct __sFILE *, long int, int);
long int ftello(struct __sFILE *);
int vfiprintf(struct __sFILE *, const char *, void *);
int iprintf(const char *, ...);
int fiprintf(struct __sFILE *, const char *, ...);
int siprintf(char *, const char *, ...);
char *tempnam(const char *, const char *);
int vasprintf(char **, const char *, void *);
int vsnprintf(char *, unsigned int, const char *, void *);
int vfscanf(struct __sFILE *, const char *, void *);
int vscanf(const char *, void *);
int vsscanf(const char *, const char *, void *);
int fcloseall(void);
int snprintf(char *, unsigned int, const char *, ...);
struct __sFILE *fdopen(int, const char *);
int fileno(struct __sFILE *);
int getw(struct __sFILE *);
int pclose(struct __sFILE *);
struct __sFILE *popen(const char *, const char *);
int putw(int, struct __sFILE *);
void setbuffer(struct __sFILE *, char *, int);
int setlinebuf(struct __sFILE *);
int getc_unlocked(struct __sFILE *);
int getchar_unlocked(void);
void flockfile(struct __sFILE *);
int ftrylockfile(struct __sFILE *);
void funlockfile(struct __sFILE *);
int putc_unlocked(int, struct __sFILE *);
int putchar_unlocked(int);
int _asprintf_r(struct _reent *, char **, const char *, ...);
int _fcloseall_r(struct _reent *);
struct __sFILE *_fdopen_r(struct _reent *, int, const char *);
struct __sFILE *_fopen_r(struct _reent *, const char *, const char *);
int _fclose_r(struct _reent *, struct __sFILE *);
int _fscanf_r(struct _reent *, struct __sFILE *, const char *, ...);
int _fseek_r(struct _reent *, struct __sFILE *, long int, int);
long int _ftell_r(struct _reent *, struct __sFILE *);
int _getchar_r(struct _reent *);
char *_gets_r(struct _reent *, char *);
int _iprintf_r(struct _reent *, const char *, ...);
int _siprintf_r(struct _reent *, char *, const char *, ...);
int _mkstemp_r(struct _reent *, char *);
char *_mktemp_r(struct _reent *, char *);
void _perror_r(struct _reent *, const char *);
int _printf_r(struct _reent *, const char *, ...);
int _putchar_r(struct _reent *, int);
int _puts_r(struct _reent *, const char *);
int _remove_r(struct _reent *, const char *);
int _rename_r(struct _reent *, const char *, const char *);
int _scanf_r(struct _reent *, const char *, ...);
int _sprintf_r(struct _reent *, char *, const char *, ...);
int _snprintf_r(struct _reent *, char *, unsigned int, const char *, ...);
int _sscanf_r(struct _reent *, const char *, const char *, ...);
char *_tempnam_r(struct _reent *, const char *, const char *);
struct __sFILE *_tmpfile_r(struct _reent *);
char *_tmpnam_r(struct _reent *, char *);
int _ungetc_r(struct _reent *, int, struct __sFILE *);
int _vasprintf_r(struct _reent *, char **, const char *, void *);
int _vfiprintf_r(struct _reent *, struct __sFILE *, const char *, void *);
int _vfprintf_r(struct _reent *, struct __sFILE *, const char *, void *);
int _vprintf_r(struct _reent *, const char *, void *);
int _vsprintf_r(struct _reent *, char *, const char *, void *);
int _vsnprintf_r(struct _reent *, char *, unsigned int, const char *, void *);
int _vfscanf_r(struct _reent *, struct __sFILE *, const char *, void *);
int _vscanf_r(struct _reent *, const char *, void *);
int _vsscanf_r(struct _reent *, const char *, const char *, void *);
int __getdelim(char **, unsigned int *, int, struct __sFILE *);
int __getline(char **, unsigned int *, struct __sFILE *);
int __srget(struct __sFILE *);
int __swbuf(int, struct __sFILE *);
struct __sFILE *funopen(const void *, int (*)(void *, char *, int), int (*)(void *, const char *, int), long int (*)(void *, long int, int), int (*)(void *));
extern int __mb_cur_max;
void abort(void);
int abs(int);
int atexit(void (*)(void));
double atof(const char *);
float atoff(const char *);
int atoi(const char *);
int _atoi_r(struct _reent *, const char *);
long int atol(const char *);
long int _atol_r(struct _reent *, const char *);
void *bsearch(const void *, const void *, unsigned int, unsigned int, int (*)(const void *, const void *));
void *calloc(unsigned int, unsigned int);
div_t div(int, int);
void exit(int);
void free(void *);
char *getenv(const char *);
char *_getenv_r(struct _reent *, const char *);
char *_findenv(const char *, int *);
char *_findenv_r(struct _reent *, const char *, int *);
long int labs(long int);
ldiv_t ldiv(long int, long int);
void *malloc(unsigned int);
int mblen(const char *, unsigned int);
int _mblen_r(struct _reent *, const char *, unsigned int, _mbstate_t *);
int mbtowc(unsigned short int *, const char *, unsigned int);
int _mbtowc_r(struct _reent *, unsigned short int *, const char *, unsigned int, _mbstate_t *);
int wctomb(char *, unsigned short int);
int _wctomb_r(struct _reent *, char *, unsigned short int, _mbstate_t *);
unsigned int mbstowcs(unsigned short int *, const char *, unsigned int);
unsigned int _mbstowcs_r(struct _reent *, unsigned short int *, const char *, unsigned int, _mbstate_t *);
unsigned int wcstombs(char *, const unsigned short int *, unsigned int);
unsigned int _wcstombs_r(struct _reent *, char *, const unsigned short int *, unsigned int, _mbstate_t *);
int mkstemp(char *);
char *mktemp(char *);
void qsort(void *, unsigned int, unsigned int, int (*)(const void *, const void *));
int rand(void);
void *realloc(void *, unsigned int);
void srand(unsigned int);
double strtod(const char *, char **);
double _strtod_r(struct _reent *, const char *, char **);
float strtof(const char *, char **);
long int strtol(const char *, char **, int);
long int _strtol_r(struct _reent *, const char *, char **, int);
unsigned long int strtoul(const char *, char **, int);
unsigned long int _strtoul_r(struct _reent *, const char *, char **, int);
int system(const char *);
long int a64l(const char *);
char *l64a(long int);
char *_l64a_r(struct _reent *, long int);
int on_exit(void (*)(int, void *), void *);
void _Exit(int);
int putenv(const char *);
int _putenv_r(struct _reent *, const char *);
int setenv(const char *, const char *, int);
int _setenv_r(struct _reent *, const char *, const char *, int);
char *gcvt(double, int, char *);
char *gcvtf(float, int, char *);
char *fcvt(double, int, int *, int *);
char *fcvtf(float, int, int *, int *);
char *ecvt(double, int, int *, int *);
char *ecvtbuf(double, int, int *, int *, char *);
char *fcvtbuf(double, int, int *, int *, char *);
char *ecvtf(float, int, int *, int *);
char *dtoa(double, int, int, int *, int *, char **);
int rand_r(unsigned int *);
double drand48(void);
double _drand48_r(struct _reent *);
double erand48(unsigned short int [3]);
double _erand48_r(struct _reent *, unsigned short int [3]);
long int jrand48(unsigned short int [3]);
long int _jrand48_r(struct _reent *, unsigned short int [3]);
void lcong48(unsigned short int [7]);
void _lcong48_r(struct _reent *, unsigned short int [7]);
long int lrand48(void);
long int _lrand48_r(struct _reent *);
long int mrand48(void);
long int _mrand48_r(struct _reent *);
long int nrand48(unsigned short int [3]);
long int _nrand48_r(struct _reent *, unsigned short int [3]);
unsigned short int *seed48(unsigned short int [3]);
unsigned short int *_seed48_r(struct _reent *, unsigned short int [3]);
void srand48(long int);
void _srand48_r(struct _reent *, long int);
long long int atoll(const char *);
long long int _atoll_r(struct _reent *, const char *);
long long int llabs(long long int);
lldiv_t lldiv(long long int, long long int);
long long int strtoll(const char *, char **, int);
long long int _strtoll_r(struct _reent *, const char *, char **, int);
unsigned long long int strtoull(const char *, char **, int);
unsigned long long int _strtoull_r(struct _reent *, const char *, char **, int);
void cfree(void *);
char *_dtoa_r(struct _reent *, double, int, int, int *, int *, char **);
void *_malloc_r(struct _reent *, unsigned int);
void *_calloc_r(struct _reent *, unsigned int, unsigned int);
void _free_r(struct _reent *, void *);
void *_realloc_r(struct _reent *, void *, unsigned int);
void _mstats_r(struct _reent *, char *);
int _system_r(struct _reent *, const char *);
void __eprintf(const char *, const char *, unsigned int, const char *);
void __cygwin_lock_init(void **);
void __cygwin_lock_init_recursive(void **);
void __cygwin_lock_fini(void **);
void __cygwin_lock_lock(void **);
int __cygwin_lock_trylock(void **);
void __cygwin_lock_unlock(void **);
extern struct _reent *_impure_ptr;
void _reclaim_reent(struct _reent *);

// interface definitions /////////////////////////////////////////////

interface i_bit64_tranceiver
{
    void receive(bit[63:0] *);
    void send(bit[63:0]);
};

interface i_bit64_sender
{
    void send(bit[63:0]);
};

interface i_bit64_receiver
{
    void receive(bit[63:0] *);
};

// behavior and channel definitions //////////////////////////////////

channel c_bit64_queue(
    in const unsigned long int size) implements i_bit64_sender, i_bit64_receiver, i_bit64_tranceiver
{
    void setup(void);

    bit[63:0] *buffer = 0;
    unsigned long int n = 0ul;
    unsigned long int p = 0ul;
    event r;
    event s;
    unsigned long int wr = 0ul;
    unsigned long int ws = 0ul;

    void cleanup(void)
    {   
	if ( !n)
	{   
	    free(buffer);
	    buffer = 0;
	}
    }

    void receive(bit[63:0] *d)
    {   
	while( !n)
	{   
	    wr++ ;
	    wait(r);
	    wr-- ;
	}
	if (n <= p)
	{   
	     *d = buffer[p - n];
	}
	else 
	{   
	     *d = buffer[p + size - n];
	}
	n-- ;
	if (ws)
	{   
	    notify(s);
	}
	cleanup();
    }

    void send(bit[63:0] d)
    {   
	while(n >= size)
	{   
	    ws++ ;
	    wait(s);
	    ws-- ;
	}
	setup();
	buffer[p] = d;
	p++ ;
	if (p >= size)
	{   
	    p = 0;
	}
	n++ ;
	if (wr)
	{   
	    notify(r);
	}
    }

    void setup(void)
    {   
	if ( !buffer)
	{   
	    if ( !(buffer = (bit[63:0] *)malloc(sizeof(bit[63:0]) * size)))
	    {   
		fputs("c_typed_queue: out of memory\n", (_impure_ptr->_stderr));
		exit(1);
	    }
	}
    }
};

//////////////////////////////////////////////////////////////////////
// End of file c_bit64_queue_dbg.sc
//////////////////////////////////////////////////////////////////////
