// double_handshake.sc: example for use of c_double_handshake
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 02/19/02 RD	initial version (based on double_handshake_test.sc


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <sim.sh>


import "c_double_handshake";	// import the standard channel


#define N	10		// number of handshake transactions


int Rnd(int Range)		// random number in range [0...Range-1]
{
    return((int)(drand48() * (double)Range));
}


behavior Sender(		// the sender behavior
    i_sender DoubleHandshake)
{
    void SendData(int s)
    {
	char Data[N];
	int  i;

	printf("Time%4s: Sender sending %d bytes.\n",
		time2str(now()), s);
	for(i=0; i<s; i++)
	{
	    Data[i] = (char) s;
	}
	DoubleHandshake.send(Data, s);
    }

    void Sleep(void)
    {
	int Duration;

	printf("Time%4s: Sender done, ",
		time2str(now()));
	Duration = Rnd(3);
	printf("going to sleep for %d time units.\n", Duration);
	if (Duration)
	    waitfor(Duration);
    }

    void main(void)
    {
	int s;

	for(s=1; s<=N; s++)
	{
	    SendData(s);
	    Sleep();
	}
    }
};


behavior Receiver(		// the receiver behavior
    i_receiver DoubleHandshake)
{
    void ReceiveData(int r)
    {
	char Data[N];
	int  i;

	printf("Time%4s: Receiver receiving %d bytes.\n",
		time2str(now()), r);
	DoubleHandshake.receive(Data, r);
	for(i=0; i<r; i++)
	{
	    assert(Data[i] == (char) r);
	}
    }

    void Sleep(void)
    {
	int Duration;

	printf("Time%4s: Receiver done, ",
		time2str(now()));
	Duration = Rnd(3);
	printf("going to sleep for %d time units.\n", Duration);
	if (Duration)
	    waitfor(Duration);
    }

    void main(void)
    {
	int r;

	for(r=1; r<=N; r++)
	{
	    ReceiveData(r);
	    Sleep();
	}
    }
};


behavior Main	// let the sender send data to the receiver through the channel
{
    c_double_handshake DoubleHandshake;
    Receiver           r1(DoubleHandshake);
    Sender             s1(DoubleHandshake);

    int main(void)
    {
	printf("Time%4s: double_handshake: Starting...\n",
		time2str(now()));
	par {	r1.main();
		s1.main();
		}
	printf("Time%4s: double_handshake: Done.\n",
		time2str(now()));
	return 0;
    }
};


// EOF double_handshake.sc
