// Piped2.sc: (updated 01/06/03, initial version 07/18/02, RD)

#include <stdio.h>
#include <assert.h>

behavior Pipe(
	in    int In,
	out   int Out,
	inout int IO)
{
    void main(void)
    {
	piped int	b1 = 0,
			b2 = 1;
	piped int	b3;
	piped int	b4[2] = { 0, 1ull };
	piped int	b5[2] = { 5, 5 };
	piped int	b6[2][2] = {{1,2}, {3,4}};
	int i;

	assert(b1 == 0);
	assert(b2 == 1);
	b1 = 1; b2 = 2;
	assert(b1 == 0);
	assert(b2 == 1);
	pipe(i=0; i<1; i++) { /* shift the pipes once */ }
	b1 = b2; b2 = b1;
	assert(b1 == 1);
	assert(b2 == 2);
	pipe(i=0; i<1; i++) { /* shift the pipes once */ }
	b1 = 42; b2 = 42;
	assert(b1 == 2);
	assert(b2 == 1);
	pipe(i=0; i<1; i++) { /* shift the pipes once */ }
	assert(b1 == 42);
	assert(b2 == 42);
	b1 = b2 - 17;
	b2 -= 25;
	assert(b1 == 42);
	assert(b2 == 42);
	pipe(i=0; i<1; i++) { /* shift the pipes once */ }
	assert(b1 == 25);
	assert(b2 == 17);

	assert(b4[0] == 0);
	assert(b4[1] == 1);
	b4[0] = 1; b4[1] = 2;
	assert(b4[0] == 0);
	assert(b4[1] == 1);
	pipe(i=0; i<1; i++) { /* shift the pipes once */ }
	b4[0] = b4[1]; b4[1] = b4[0];
	assert(b4[0] == 1);
	assert(b4[1] == 2);
	pipe(i=0; i<1; i++) { /* shift the pipes once */ }
	b4[0] = 42; b4[1] = 42;
	assert(b4[0] == 2);
	assert(b4[1] == 1);
	pipe(i=0; i<1; i++) { /* shift the pipes once */ }
	assert(b4[0] == 42);
	assert(b4[1] == 42);
	b4[0] = b4[1] - 17;
	b4[1] -= 25;
	assert(b4[0] == 42);
	assert(b4[1] == 42);
	pipe(i=0; i<1; i++) { /* shift the pipes once */ }
	assert(b4[0] == 25);
	assert(b4[1] == 17);

	assert(b4[0] == 25); assert(b4[1] == 17);
	assert(b5[0] ==  5); assert(b5[1] ==  5);
	b5 = b4;
	assert(b4[0] == 25); assert(b4[1] == 17);
	assert(b5[0] ==  5); assert(b5[1] ==  5);
	pipe(i=0; i<1; i++) { /* shift the pipes once */ }
	assert(b4[0] == 25); assert(b4[1] == 17);
	assert(b5[0] == 25); assert(b5[1] == 17);
	b5[1] = b4[0];
	b5[0] = b4[1];
	assert(b4[0] == 25); assert(b4[1] == 17);
	assert(b5[0] == 25); assert(b5[1] == 17);
	pipe(i=0; i<1; i++) { /* shift the pipes once */ }
	assert(b4[0] == 25); assert(b4[1] == 17);
	assert(b5[0] == 17); assert(b5[1] == 25);

	assert(b6[0][0] ==  1); assert(b6[0][1] ==  2);
	assert(b6[1][0] ==  3); assert(b6[1][1] ==  4);
	b6[0][0] = -1; b6[1][1] = -2;
	assert(b6[0][0] ==  1); assert(b6[0][1] ==  2);
	assert(b6[1][0] ==  3); assert(b6[1][1] ==  4);
	pipe(i=0; i<1; i++) { /* shift the pipes once */ }
	assert(b6[0][0] == -1); assert(b6[0][1] ==  2);
	assert(b6[1][0] ==  3); assert(b6[1][1] == -2);
	b6[1] = b5;
	assert(b6[0][0] == -1); assert(b6[0][1] ==  2);
	assert(b6[1][0] ==  3); assert(b6[1][1] == -2);
	pipe(i=0; i<1; i++) { /* shift the pipes once */ }
	assert(b6[0][0] == -1); assert(b6[0][1] ==  2);
	assert(b6[1][0] == 17); assert(b6[1][1] == 25);
	b6[0][0]++; b6[0][1] -= 2;
	b6[1][0] = b6[1][1]; b6[1][1] = b6[1][0];
	assert(b6[0][0] == -1); assert(b6[0][1] ==  2);
	assert(b6[1][0] == 17); assert(b6[1][1] == 25);
	pipe(i=0; i<1; i++) { /* shift the pipes once */ }
	assert(b6[0][0] ==  0); assert(b6[0][1] ==  0);
	assert(b6[1][0] == 25); assert(b6[1][1] == 17);

	b4[0] = b2; b2 = b4[0];
	assert(b4[0] == 25); assert(b4[1] == 17); assert(b2 == 17);
	pipe(i=0; i<1; i++) { /* shift the pipes once */ }
	assert(b4[0] == 17); assert(b4[1] == 17); assert(b2 == 25);
	b6[0] = b4; b4 = b6[0];
	assert(b6[0][0] ==  0); assert(b6[0][1] ==  0);
	assert(b4[0] == 17); assert(b4[1] == 17);
	pipe(i=0; i<1; i++) { /* shift the pipes once */ }
	assert(b6[0][0] == 17); assert(b6[0][1] == 17);
	assert(b4[0] ==  0); assert(b4[1] ==  0);

	{
	    int s1 = 1;
	    int s2[2] = { 2, 3 };
	    int s3[2][2] = {{4,5}, {6,7}};

	    b1 = s1;
	    b2 = s2[0];
	    b4 = s2;
	    b5 = s3[0];
	    assert(b1 == 25);
	    assert(b2 == 25);
	    assert(b4[0] ==  0); assert(b4[1] ==  0);
	    assert(b5[0] == 17); assert(b5[1] == 25);
	    pipe(i=0; i<1; i++) { /* shift the pipes once */ }
	    assert(b1 == 1);
	    assert(b2 == 2);
	    assert(b4[0] == 2); assert(b4[1] == 3);
	    assert(b5[0] == 4); assert(b5[1] == 5);

	    b4[0] = s1;
	    b5[0] = s2[0];
	    b6[0] = s2;
	    b6[1] = s3[0];
	    assert(b4[0] == 2); assert(b4[1] == 3);
	    assert(b5[0] == 4); assert(b5[1] == 5);
	    assert(b6[0][0] == 17); assert(b6[0][1] == 17);
	    assert(b6[1][0] == 25); assert(b6[1][1] == 17);
	    pipe(i=0; i<1; i++) { /* shift the pipes once */ }
	    assert(b4[0] == 1); assert(b4[1] == 3);
	    assert(b5[0] == 2); assert(b5[1] == 5);
	    assert(b6[0][0] == 2); assert(b6[0][1] == 3);
	    assert(b6[1][0] == 4); assert(b6[1][1] == 5);
	}

	{
	    piped bit[8] v1;
	    piped bit[8] v4[2];
	    piped bit[8] v6[2][2];

	    if (!(b1)) { assert(false); }
	    if (!(b4[0])) { assert(false); }
	    if (!(b6[1][1])) { assert(false); }
	    v1 = b1;
	    v4[0] = b4[0];
	    v6[1][1] = b6[1][1];
	    pipe(i=0; i<1; i++) { /* shift the pipes once */ }
	    if (!(v1)) { assert(false); }
	    if (!(v4[0])) { assert(false); }
	    if (!(v6[1][1])) { assert(false); }
	    if (!(v1[0])) { assert(false); }
	    if (!(v4[0][0])) { assert(false); }
	    if (!(v6[1][1][0])) { assert(false); }
	}
    }
};


struct S { int a, b, c; };

behavior Struct
{
    void main(void)
    {
	int i;
	piped struct S ps1 = { 0,1,2 };
	piped struct S ps2 = { 4,5,6 };

	assert(ps1.a == 0);
	assert(ps1.b == 1);
	assert(ps1.c == 2);
	ps1.a = 1; ps1.b = 2;
	assert(ps1.a == 0);
	assert(ps1.b == 1);
	pipe(i=0; i<1; i++) { /* shift the pipes once */ }
	ps1.a = ps1.b; ps1.b = ps1.a;
	assert(ps1.a == 1);
	assert(ps1.b == 2);
	pipe(i=0; i<1; i++) { /* shift the pipes once */ }
	ps1.a = 42; ps1.b = 42;
	assert(ps1.a == 2);
	assert(ps1.b == 1);
	pipe(i=0; i<1; i++) { /* shift the pipes once */ }
	assert(ps1.a == 42);
	assert(ps1.b == 42);
	ps1.a = ps1.b - 17;
	ps1.b -= 25;
	assert(ps1.a == 42);
	assert(ps1.b == 42);
	pipe(i=0; i<1; i++) { /* shift the pipes once */ }
	assert(ps1.a == 25);
	assert(ps1.b == 17);

	assert(ps1.a == 25);
	assert(ps1.b == 17);
	assert(ps1.c == 2);
	assert(ps2.a == 4);
	assert(ps2.b == 5);
	assert(ps2.c == 6);
	ps1 = ps2;
	ps2 = ps1;
	assert(ps1.a == 25);
	assert(ps1.b == 17);
	assert(ps1.c == 2);
	assert(ps2.a == 4);
	assert(ps2.b == 5);
	assert(ps2.c == 6);
	pipe(i=0; i<1; i++) { /* shift the pipes once */ }
	assert(ps1.a == 4);
	assert(ps1.b == 5);
	assert(ps1.c == 6);
	assert(ps2.a == 25);
	assert(ps2.b == 17);
	assert(ps2.c == 2);
    }
};


behavior Main
{
    int b1, b2, b3;
    Pipe B1(b1, b2, b3);
    Struct B2;

    int main(void)
    {
	puts("Pipe test starting...");

	puts("Running test 1 (behavior 'Pipe')...");
	B1.main();
	puts("OK. Done.");

	puts("Running test 2 (behavior 'Struct')...");
	B2.main();
	puts("OK. Done.");

	puts("Pipe test completed.");
	return(0);
    }
};

// eof
