// DbgGen.sc: test case for 'sir_gen'
//
// 01/12/04 AG	_SIR_MANGLED_SUFFIX not a string any more
// 11/18/02 RD	completed version
// 11/11/02 RD	initial version


#define BOOL_DFLT	true
#define CHAR_DFLT	'x'
#define UCHAR_DFLT	'y'
#define SHORT_DFLT	(short) 42
#define USHORT_DFLT	(unsigned short) 42
#define INT_DFLT	-100
#define UINT_DFLT	100u
#define LONG_DFLT	-10000l
#define ULONG_DFLT	10000ul
#define LLONG_DFLT	-10000ll
#define ULLONG_DFLT	10000ull
#define FLOAT_DFLT	123.456f
#define DOUBLE_DFLT	1234567890.1234567890
#define LDOUBLE_DFLT	3.1415927l
#define BIT_DFLT	00110011b
#define UBIT_DFLT	111100001111ub
#define STRING_DFLT	"abc" "def xyz!@#$%!"


#define STR(a,b)  #a #b
#define NAME(a,b) STR(a,b)

#ifndef _SIR_MANGLED_SUFFIX
#define _SIR_MANGLED_SUFFIX __DbgGen
#endif

#ifndef BOOL
#define BOOL BOOL_DFLT
#endif
#ifndef CHAR
#define CHAR CHAR_DFLT
#endif
#ifndef UCHAR
#define UCHAR UCHAR_DFLT
#endif
#ifndef SHORT
#define SHORT SHORT_DFLT
#endif
#ifndef USHORT
#define USHORT USHORT_DFLT
#endif
#ifndef INT
#define INT INT_DFLT
#endif
#ifndef UINT
#define UINT UINT_DFLT
#endif
#ifndef LONG
#define LONG LONG_DFLT
#endif
#ifndef ULONG
#define ULONG ULONG_DFLT
#endif
#ifndef LLONG
#define LLONG LLONG_DFLT
#endif
#ifndef ULLONG
#define ULLONG ULLONG_DFLT
#endif
#ifndef FLOAT
#define FLOAT FLOAT_DFLT
#endif
#ifndef BIT
#define BIT BIT_DFLT
#endif
#ifndef UBIT
#define UBIT UBIT_DFLT
#endif
#ifndef DOUBLE
#define DOUBLE DOUBLE_DFLT
#endif
#ifndef LDOUBLE
#define LDOUBLE LDOUBLE_DFLT
#endif
#ifndef STRING
#define STRING STRING_DFLT
#endif

behavior debug(out unsigned bit[UINT-1:0] o,
              in  unsigned bit[UINT-1:0] a,
              in  unsigned bit[UINT-1:0] b,
              in  event clk)
{
  // library information    
  note _RT_LIBRARY = true;
  note _RT_CATEGORY = "FU";
  note _RT_OPERATION = "*";

  // attributes
  note _RT_CLOCK = { 100e6, 1.0, 100e6 };
  note _RT_BITWIDTH = UINT;

  // unit information  
  note _RT_OUTPUT_DELAY= 1.0;    
  note _RT_STAGES = 1;

  // area/cost information	
  note _RT_AREA= 600.0;   
  note _RT_COST= 8.0;	
  note _RT_POWER = 0.3;

  // information about additional models
  note _RT_BF_MODEL = NAME(debug_BF,_SIR_MANGLED_SUFFIX);
  
  // parameters
  note _SIR_PARAMETERS = {
    { "BOOL", BOOL_DFLT, { true, false }, "bool", "" },
    { "CHAR", CHAR_DFLT, { 'a', 'b', 'c' }, "char", "" },
    { "UCHAR", UCHAR_DFLT, { 'a', 'b', 'c' }, "unsigned char", "" },
    { "SHORT", SHORT_DFLT, { {(short)-4, (short)+42} }, "short", "" },
    { "USHORT", USHORT_DFLT, { (unsigned short)42,
				(unsigned short)43 }, "unsigned short", "" },
    { "INT", INT_DFLT, { {1, 128}, {-128,-1} }, "int", "" },
    { "UINT", UINT_DFLT, { {1u, 128u}, {129u,256u} }, "unsigned int", "" },
    { "LONG", LONG_DFLT, { {1l, 128l}, {-128l,-1l} }, "long", "" },
    { "ULONG", ULONG_DFLT, {{1ul, 128ul},{129ul,256ul}}, "unsigned long", "" },
    { "LLONG", LLONG_DFLT, { {1ll,128ll},{-128ll,-1ll} }, "long long", "" },
    { "ULLONG", ULLONG_DFLT, {{1ull,1024ull}}, "unsigned long long", "" },
    { "FLOAT", FLOAT_DFLT, {{0.1f,2.2f}}, "float", "" },
    { "DOUBLE", DOUBLE_DFLT, {{-1.1,3.3e8}}, "double", "" },
    { "LDOUBLE", LDOUBLE_DFLT, {{-1.1e9l,2.2e25l}}, "long double", "" },
    { "BIT", BIT_DFLT, {{01100b,01110b}}, "bit", "" },
    { "UBIT", UBIT_DFLT, {{1100ub,11100ub}}, "unsigned bit", "" },
    { "STRING", STRING_DFLT, {{"Atest", "Btest"}}, "string", "" }
  };

  const bool b0 = BOOL;
  const char c0 = CHAR;
  const unsigned char uc0 = UCHAR;
  const short s0 = SHORT;
  const unsigned short us0 = USHORT;
  const int i0 = INT;
  const unsigned int ui0 = UINT;
  const long l0 = LONG;
  const unsigned long ul0 = ULONG;
  const long long ll0 = LLONG;
  const unsigned long long ull0 = ULLONG;
  const float f0 = FLOAT;
  const double d0 = DOUBLE;
  const long double ld0 = LDOUBLE;
  const bit[5] bit0 = BIT;
  const unsigned bit[5] ubit0 = UBIT;
  const char *str0 = STRING;

  void main(void)
  {
    static bit[UINT-1:0] product;

    o = product;
    product = a * b;
  }
};


behavior debug_BF();

// EOF
