/************************************************************************/
/* IntRep/Initializer.h: SpecC Internal Representation, Initializer Cl.	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 02/10/98 */
/************************************************************************/

/* last update: 06/15/04 */

/* modifications: (most recent first)
 *
 * 06/15/04 PC  Adjustments for scrc 2.0
 * 01/15/02 RD	added support for composite annotations
 * 11/08/01 RD	switched code generation to use GL_IO layer
 * 09/28/01 RD	improved indentation of generated code
 * 05/31/01 RD	eliminated level 2 of SIR API
 * 05/25/01 RD	eliminated support for binary SIR files (import/export)
 * 05/25/01 RD	introduced this header (last change was 04/12/99)
 */

#ifndef INTREP_INITIALIZER_H
#define INTREP_INITIALIZER_H


#include "Global.h"
#include "IntRep/Constant.h"


/*** enumeration types **************************************************/


	/* none */


/*** type definitions ***************************************************/


typedef class SIR_Initializer		sir_initializer;
typedef SIR_List<sir_initializer>	sir_init_list;
typedef class SIR_Initials		sir_initials;


/*** class declarations *************************************************/


	/***********************/
	/*** SIR_Initializer ***/
	/***********************/


class SIR_Initializer :		/* initializer of a variable */
	public SIR_ListElem<SIR_Initializer>	/* is a list element */
{
public:
sir_initials	*InitList;	/* either: list of initializers */
sir_constant	*Initializer;	/* or:     one constant         */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Initializer(		/* constructor #1 */
	sir_initials	*InitList,
	sir_constant	*Initializer);

SIR_Initializer(		/* constructor #3 (duplicator) */
	sir_initializer	*Original);

~SIR_Initializer(void);		/* destructor */


unsigned int GetAutoArraySize(  /* compute the implicit array size */
        void);                  /* (must be valid array initializer) */


ERROR DFS_ForAllNodes(		/* iterator over all nodes (depth first) */
	sir_node_mptr	MemberFct,
	sir_node_marg	MemberFctArg);

BOOL IsComposite(               /* checks if initializer is composite */
        BOOL            TargetIsArray);

ERROR WriteSC(			/* (re-) generates SpecC source code */
	GL_HANDLE	*IO,
	BOOL		CplusplusMode,
	BOOL		StartNewLine = TRUE);

const char *Print(              /* create SpecC source code (1 line) */
        string          *Buffer = NULL);        /* (NULL = internal buffer) */

};


	/********************/
	/*** SIR_Initials ***/
	/********************/


class SIR_Initials :		/* list of initializers */
	public SIR_List<SIR_Initializer>/* is simply a list of initializers */
{					/* with additional methods */
public:

//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Initials(			/* constructor #1 */
	sir_initializer	*NewFirstEntry = NULL);

SIR_Initials(			/* constructor #2 (duplicator) */
	sir_initials	*Original);	/* (returns NULL if SIR_Error) */

~SIR_Initials(void);		/* destructor */


ERROR DFS_ForAllNodes(		/* iterator over all nodes (depth first) */
	sir_node_mptr	MemberFct,
	sir_node_marg	MemberFctArg);
};


/*** exported functions *************************************************/


	/* none */


#endif /* INTREP_INITIALIZER_H */

/* EOF IntRep/Initializer.h */
