/************************************************************************/
/* IntRep/BasicType.h: SpecC Internal Representation, Basic Type Class	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 10/07/97 */
/************************************************************************/

/* last update: 04/12/99 */

/* NOTE: This file contains special support for the SpecC parser. */
/*       It is not used in a standard SpecC data structure.	  */

#ifndef INTREP_BASICTYPE_H
#define INTREP_BASICTYPE_H


#include "Global.h"
#include "IntRep/Symbol.h"


/*** constants and macros ***********************************************/


	/* none */


/*** enumeration types **************************************************/


enum SIR_BasicTypeType		/* intermediate types */
{				/* (see class SIR_BasicType) */
SIR_BASICTYPE_BOOL		= SIR_TYPE_BOOL,
SIR_BASICTYPE_CHAR		= SIR_TYPE_CHAR,
SIR_BASICTYPE_SHORT		= SIR_TYPE_SHORT,
SIR_BASICTYPE_INT		= SIR_TYPE_INT,
SIR_BASICTYPE_LONG		= SIR_TYPE_LONG,
SIR_BASICTYPE_LONGLONG		= SIR_TYPE_LONGLONG,
SIR_BASICTYPE_FLOAT		= SIR_TYPE_FLOAT,
SIR_BASICTYPE_DOUBLE		= SIR_TYPE_DOUBLE,
SIR_BASICTYPE_LONGDOUBLE	= SIR_TYPE_LONGDOUBLE,
SIR_BASICTYPE_BIT		= SIR_TYPE_BIT,
SIR_BASICTYPE_VOID		= SIR_TYPE_VOID,
SIR_BASICTYPE_EVENT		= SIR_TYPE_EVENT,
SIR_BASICTYPE_UNKNOWN
};


/*** type definitions ***************************************************/


typedef enum SIR_BasicTypeType		SIR_BASICTYPE;

typedef class SIR_BasicType		sir_basic_type;


/*** class declarations *************************************************/


	/*********************/
	/*** SIR_BasicType ***/
	/*********************/


class SIR_BasicType		/* intermediate basic type */
{				/* (during parsing) */
public:
SIR_BASICTYPE	BasicType;
bool		IsSigned;
bool		IsUnsigned;
bool		IsConst;
bool		IsVolatile;
int		LeftBound;
int		RightBound;
bool		DefinedInt;
SIR_STORAGE	StorageClass;	/* used only in declarations */
int		PipeStages;	/* used only in declarations */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_BasicType(				/* constructor #1 (standard) */
	SIR_BASICTYPE	BasicType,
	bool		IsSigned = false,
	bool		IsUnsigned = false,
	bool		IsConst = false,
	bool		IsVolatile = false,
	int		LeftBound = 0,
	int		RightBound = 0);

SIR_BasicType(				/* constructor #2 (for declarations) */
	SIR_STORAGE	StorageClass,
	int		PipeStages = 0,	/* (auto 1) */
	bool		IsConst = false,
	bool		IsVolatile = false);

~SIR_BasicType(void);			/* destructor */

sir_basic_type *Merge(			/* merges the argument into itself */
	sir_basic_type	*Other);	/* (returns NULL if SIR_Error) */
};


#endif /* INTREP_BASICTYPE_H */

/* EOF IntRep/BasicType.h */
