// mutex.sc: example for use of c_mutex
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 02/13/02 RD	initial version (based on mutex_test.sc)


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <sim.sh>

import "c_mutex";	// import the standard channel


int Rnd(int Range)		// random number in range [0...Range-1]
{
    return((int)(drand48() * (double)Range));
}


behavior Competitor(		// competitor for mutex
    i_semaphore Mutex,
    inout int   CriticalData,
    inout int   CriticalUser,
    in    int   ID)
{
    void CriticalRegion(int User, int Duration)
    {
	CriticalData++;
	assert(CriticalUser == 0);	// nobody must use this except me!
	CriticalUser = User;
	printf("Time%4s: Competitor %d acquired mutex"
		" for %d time units: data = %d.\n",
		time2str(now()), CriticalUser, Duration, CriticalData);
	if (Duration)
	    waitfor(Duration);
	assert(CriticalUser == User);	// nobody must use this except me!
	CriticalUser = 0;
    }

    void WorkWithMutex(void)
    {
	int Duration;

	printf("Time%4s: Competitor %d trying to acquire the mutex.\n",
		time2str(now()), ID);
	if (Mutex.attempt())
	{
	    printf("Time%4s: Attempt immediately successful!\n",
			time2str(now()));
	}
	else
	{
	    printf("Time%4s: Attempt not successful, waiting.\n",
			time2str(now()));
	    Mutex.acquire();
	}
	Duration = Rnd(10);
	CriticalRegion(ID, Duration);
	Mutex.release();
    }

    void Sleep(void)
    {
	int Duration;

	printf("Time%4s: Competitor %d releasing mutex, ",
		time2str(now()), ID);
	Duration = Rnd(10);
	printf("going to sleep for %d time units.\n", Duration);
	if (Duration)
	    waitfor(Duration);
    }

    void main(void)
    {
	int i;

	for(i=0; i<10; i++)
	{
	    WorkWithMutex();
	    Sleep();
	}
    }
};


behavior Main			// let 5 behaviors compete for the mutex
{
    c_mutex Mutex;
    int     CriticalData = 0;
    int     CriticalUser = 0;

    Competitor c1(Mutex, CriticalData, CriticalUser, 1);
    Competitor c2(Mutex, CriticalData, CriticalUser, 2);
    Competitor c3(Mutex, CriticalData, CriticalUser, 3);
    Competitor c4(Mutex, CriticalData, CriticalUser, 4);
    Competitor c5(Mutex, CriticalData, CriticalUser, 5);

    int main(void)
    {
	printf("Time%4s: mutex: Starting...\n",
		time2str(now()));
	par {	c1.main();
		c2.main();
		c3.main();
		c4.main();
		c5.main();
		}
	printf("Time%4s: mutex: Done.\n",
		time2str(now()));
	return 0;
    }
};


// EOF mutex.sc
