// token_test2.sc: test bench for c_token.sc
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 02/12/02 RD	applied naming convention, integrated with distribution
// 02/07/02 RD	initial version, one sender thread and one receiver thread


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <sim.sh>


#define N		200	// total number of tokens fired

import "c_token";


int Rnd(int Range)		// random number in range [0...Range-1]
{
    return((unsigned int)(drand48() * (double)Range));
}


behavior Producer(
    i_producer Token)
{
    void ProduceToken(int s)
    {
	printf("Time%4s: Producer producing %d tokens.\n",
		time2str(now()), s);
	Token.produce(s);
    }

    void Sleep(void)
    {
	int Duration;

	printf("Time%4s: Producer done, ",
		time2str(now()));
	Duration = Rnd(10);
	printf("going to sleep for %d time units.\n", Duration);
	if (Duration)
	    waitfor(Duration);
    }

    void main(void)
    {
	int s = 0,
	    t;

	while (s < N)
	{
	    if (N-s > 10)
	    {
		t = Rnd(10)+1;
	    }
	    else
	    {
		t = Rnd(N-s)+1;
	    }
	    ProduceToken(t);
	    s += t;
	    Sleep();
	}
    }
};


behavior Consumer(
    i_consumer Token)
{
    void ConsumeToken(int r)
    {
	printf("Time%4s: Consumer consuming %d tokens.\n",
		time2str(now()), r);
	Token.consume(r);
    }

    void Sleep(void)
    {
	int Duration;

	printf("Time%4s: Consumer done, ",
		time2str(now()));
	Duration = Rnd(10);
	printf("going to sleep for %d time units.\n", Duration);
	if (Duration)
	    waitfor(Duration);
    }

    void main(void)
    {
	int r = 0,
	    t;

	while (r < N)
	{
	    if (N-r > 10)
	    {
		t = Rnd(10)+1;
	    }
	    else
	    {
		t = Rnd(N-r)+1;
	    }
	    ConsumeToken(t);
	    r += t;
	    Sleep();
	}
    }
};


behavior Main			// test bench for token
{
    c_token   Token;
    Consumer  r1(Token);
    Producer  s1(Token);

    int main(void)
    {
	printf("Time%4s: token_test2: Starting...\n",
		time2str(now()));
	printf("Time%4s: Running 1 consumer, 1 producer.\n",
		time2str(now()));
	par {	r1.main();
		s1.main();
		}
	printf("Time%4s: token_test2: Done.\n",
		time2str(now()));
	return 0;
    }
};


// EOF token_test2.sc
