// queue_test2.sc: test bench for c_queue.sc
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 02/14/02 RD	applied naming convention, integrated with distribution
// 02/05/02 RD	initial version, 1 sender thread and 1 receiver thread


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <sim.sh>


#define QUEUE_SIZE	200	// length of the queue
#define N		100	// number of read and write transactions
				// (less than queue size!)

import "c_queue";


int Rnd(int Range)		// random number in range [0...Range-1]
{
    return((unsigned int)(drand48() * (double)Range));
}


behavior Sender(
    i_sender Queue)
{
    void SendData(int s)
    {
	char Data[QUEUE_SIZE];
	int  i;

	assert(s >= 0);
	assert(s <= QUEUE_SIZE);
	printf("Time%4s: Sender storing %d bytes.\n",
		time2str(now()), s);
	for(i=0; i<s; i++)
	{
	    Data[i] = (char) s;
	}
	Queue.send(Data, s);
    }

    void Sleep(void)
    {
	int Duration;

	printf("Time%4s: Sender done, ",
		time2str(now()));
	Duration = Rnd(10);
	printf("going to sleep for %d time units.\n", Duration);
	if (Duration)
	    waitfor(Duration);
    }

    void main(void)
    {
	int s;

	for(s=1; s<=N; s++)
	{
	    SendData(s);
	    Sleep();
	}
    }
};


behavior Receiver(
    i_receiver Queue)
{
    void ReceiveData(int r)
    {
	char Data[QUEUE_SIZE];
	int  i;

	assert(r >= 0);
	assert(r <= QUEUE_SIZE);
	printf("Time%4s: Receiver loading %d bytes.\n",
		time2str(now()), r);
	Queue.receive(Data, r);
	for(i=0; i<r; i++)
	{
	    assert(Data[i] == (char) r);
	}
    }

    void Sleep(void)
    {
	int Duration;

	printf("Time%4s: Receiver done, ",
		time2str(now()));
	Duration = Rnd(10);
	printf("going to sleep for %d time units.\n", Duration);
	if (Duration)
	    waitfor(Duration);
    }

    void main(void)
    {
	int r;

	for(r=1; r<=N; r++)
	{
	    ReceiveData(r);
	    Sleep();
	}
    }
};


behavior Main			// test bench for queue
{
    c_queue   Queue(((const unsigned long)QUEUE_SIZE));
    Receiver  r1(Queue);
    Sender    s1(Queue);

    int main(void)
    {
	printf("Time%4s: queue_test2: Starting...\n",
		time2str(now()));
	printf("Time%4s: Running 1 receiver, 1 sender.\n",
		time2str(now()));
	par {	r1.main();
		s1.main();
		}
	printf("Time%4s: queue_test2: Done.\n",
		time2str(now()));
	return 0;
    }
};


// EOF queue_test2.sc
