// critical_section_test.sc: test bench for c_critical_section.sc
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 02/12/02 RD	applied naming convention, integrated with distribution
// 01/23/02 RD	initial version (based on mutex_test.sc)


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <sim.sh>

import "c_critical_section";


int Rnd(int Range)		// random number in range [0...Range-1]
{
    return((unsigned int)(drand48() * (double)Range));
}


behavior Competitor(		// competitor for critical section
    i_critical_section CriticalSection,
    inout int          CriticalData,
    inout int          CriticalUser,
    in    int          ID)
{
    void CriticalRegion(int User, int Duration)
    {
	CriticalData++;
	assert(CriticalUser == 0);	// nobody must use this except me!
	CriticalUser = User;
	printf("Time%4s: Competitor %d in critical section"
		" for %d time units: data = %d.\n",
		time2str(now()), CriticalUser, Duration, CriticalData);
	if (Duration)
	    waitfor(Duration);
	assert(CriticalUser == User);	// nobody must use this except me!
	CriticalUser = 0;
    }

    void WorkInCriticalSection(void)
    {
	int Duration;

	printf("Time%4s: Competitor %d trying to enter critical section.\n",
		time2str(now()), ID);
	CriticalSection.enter();
	Duration = Rnd(10);
	CriticalRegion(ID, Duration);
	CriticalSection.leave();
    }

    void Sleep(void)
    {
	int Duration;

	printf("Time%4s: Competitor %d leaving, ",
		time2str(now()), ID);
	Duration = Rnd(10);
	printf("going to sleep for %d time units.\n", Duration);
	if (Duration)
	    waitfor(Duration);
    }

    void main(void)
    {
	int i;

	for(i=0; i<10; i++)
	{
	    WorkInCriticalSection();
	    Sleep();
	}
    }
};


behavior Main			// test bench for critical_section
{
    c_critical_section CriticalSection;
    int                CriticalData = 0;
    int                CriticalUser = 0;

    Competitor c1(CriticalSection, CriticalData, CriticalUser, 1);
    Competitor c2(CriticalSection, CriticalData, CriticalUser, 2);
    Competitor c3(CriticalSection, CriticalData, CriticalUser, 3);
    Competitor c4(CriticalSection, CriticalData, CriticalUser, 4);
    Competitor c5(CriticalSection, CriticalData, CriticalUser, 5);

    int main(void)
    {
	printf("Time%4s: critical_section_test: Starting...\n",
		time2str(now()));
	par {	c1.main();
		c2.main();
		c3.main();
		c4.main();
		c5.main();
		}
	assert(CriticalData == 50);
	assert(CriticalUser == 0);
	printf("Time%4s: critical_section_test: Done.\n",
		time2str(now()));
	return 0;
    }
};


// EOF critical_section_test.sc
