// reverse.sc

// Regression test for bug when slicing reverse mapped bit vectors (l < r).


#include <stdio.h>
#include <assert.h>

behavior something_1(
		     inout unsigned bit[0:1] a
		   )
{
  void main(void)
    {
      //a = 10b;
      a[0]=0b;
      a[1]=1b;

      printf("\nsomething_1\n");
      printf("a[0]=%d\n", (int)a[0]);  assert(a[0] == 0);
      printf("a[1]=%d\n", (int)a[1]);  assert(a[1] == 1);
    }
};

behavior something_2(
		   inout unsigned bit[1:0] a
		   )
{
  void main(void)
    {
      //a = 10b;
      a[0]=0b;
      a[1]=1b;

      printf("\nsomething_2\n");
      printf("a[0]=%d\n", (int)a[0]);  assert(a[0] == 0);
      printf("a[1]=%d\n", (int)a[1]);  assert(a[1] == 1);
    }
};



behavior Main(void)
{
  unsigned bit[1:0] a_1;
  unsigned bit[1:0] a_2;
  
  something_1 do_something_1(a_1);  
  something_2 do_something_2(a_2);  


  int main(void)
    {
      
      do_something_1.main();
      do_something_2.main();

      printf("a_1 = %d\n", (int)a_1);
      if (a_1 != 1) {
        printf("### Should be 1!\n");
	return 1;
      }
      printf("a_2 = %d\n", (int)a_2);
      if (a_2 != 2) {
        printf("### Should be 2!\n");
	return 1;
      }

      return(0);
    }
};

// EOF


