// Fsmd.sc: test cases for 'fsmd' statement

#include <stdio.h>

behavior InternalFsmd
{
    void main(void)
    {   
	buffered[10u] bit[7:0] i;
	bool _status_;

			// limited control flow analysis (10/30/03, RD):

	switch(i) {}	// empty switch statement, OK
//	case 5:		// case outside switch, ERROR
//	default:	// default outside switch, ERROR
//	continue;	// continue outside loop, ERROR
//	break;		// break outside loop or switch, ERROR

			// not checked at this time (10/30/03):

			// - multiple case statements with same value
			// - multiple default statements

//	fsmd(10u){ /* empty */ }	// warning: no states!

	fsmd(10u){
//	    if (!_status_)
//	    {
//	//	goto S0;		// warning: no next state in reset state
//	    }
	    S0:
	    {   puts("state S0");
		goto S1;
	    }
	    S1:
	    {   puts("state S1");
		L_S1_0: i = 0;
		goto S2;
	    }
	    S2:
	    {   puts("state S2");
		i++;
		printf(" i = %d\n", (int)i);
		L_S2_0: _status_ = i < 42;
		if (_status_)
		{   
		    goto S2;
		}
		else 
		{
		    if (i[1])
			goto S3;
		    else
			break;
		}
	    }
	    S3:
	    {   puts("state S3");
		goto S4;
	    }
	    S4:
	    {   puts("state S4");

				// limited control flow analysis here too:

//		case 4:		// case outside switch, ERROR
//		default:	// default outside switch, ERROR
//		continue;	// not applicable
//		break;		// if not in switch, exits 'fsmd'

				// not checked at this time:
				// - multiple case with same value

		switch(i[2:3])		// further restrictions:
		{
		    case 0:  { goto S5;	// only this "well-defined" kind of
			       break; }	// switch statement is allowed in 'fsmd';
		    case 1:  { goto S6;	// there is currently no support for:
			       break; }	// - case/default/break at any other levels
		    case 2:  { goto S7;	// - multiple case for one block
			       break; }	// - other statements in between the
		    default: { goto S8;	//   case/default level
			       break; }	// - fall-through cases
		}
	    }
	    S5:
	    {   puts("state S5");
		goto S6;
	    }
	    S6:
	    {   puts("state S6");
		goto S7;
	    }
	    S7:
	    {   puts("state S7");
		if (false)
			goto S8;
		else
			break;
	    }
	    S8:
	    {   puts("state S8");
		goto S9;
	    }
	    S9:
	    {   puts("state S9");
		break;
	    }
	    S_never_reached:
	    {
		goto S_never_reached;	// warning: state never reached!
	    }
	}
    }
};

behavior Main
{
    InternalFsmd	f0;

    int main(void)
    {
	f0;
	return(0);
    }
};
