/* FSM2.sc: test file for a DIRTY SpecC FSM description	*/
/* -------						*/

#include <stdlib.h>
#include <stdio.h>


bool	Condition1 = false,
	Condition2 = true;

event	Event1,
	Event2;

behavior State1 { void main(void){ printf("State 1 active...\n"); } };
behavior State2 { void main(void){ printf("State 2 active...\n"); } };
behavior State3 { void main(void){ printf("State 3 active...\n"); } };
behavior State4 { void main(void){ printf("State 4 active...\n"); } };
behavior State5 { void main(void){ printf("State 5 active...\n"); } };
behavior State6 { void main(void){ printf("State 6 active...\n"); } };

behavior Main /* FSM */
{

State1	S1;
State2	S2;
State3	S3;
State4	S4;
State5	S5;
State6	S6;

int main(void)
{
int	NextState = 1;

while(NextState) switch(NextState)
   { case 1:
	{ S1.main();
	  NextState = 2;
	  break;
	 }
     case 2:
	{ S2.main();
	  if (Condition1)
		NextState = 2;
	  else
		NextState = 3;
	  break;
	 }
     case 3:
	{ S3.main();
	  if (Condition2 || Condition1)
		NextState = 4;
	  else
		NextState = 2;
	  break;
	 }
     case 4:
	{ try { S4.main(); }
		interrupt (Event1) { S6.main(); }
		interrupt (Event2) { S5.main(); };
	  NextState = 5;
	  break;
	 }
     case 5:
	{ try { S5.main(); }
		trap (Event1, Event2) { S4.main(); };
	  NextState = 6;
	  break;
	 }
     case 6:
	{ try { S6.main(); }
		interrupt (Event1) { S3.main(); }
		trap (Event2) { S1.main(); };
	  NextState = 0;
	  break;
	 }
     default:
	{ puts("ERROR: BAD NEXTSTATE!!!");
	  abort();
	 }
    } /* hctiws/elihw */

return 0;

} /* end of main */

}; /* end of Main */

/* EOF */
