/************************************************************************/
/* Member.cc: SpecC Internal Representation, Member Class		*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 10/08/97 */
/************************************************************************/

/* last update: 11/21/01 */

/* modifications: (most recent first)
 *
 * 11/21/01 RD	took out default arguments from function definitions
 * 05/31/01 RD	eliminated level 2 of SIR API
 * 05/25/01 RD	eliminated support for binary SIR files (import/export)
 * 01/30/01 RD	fixed a potential FMR problem in iterator
 *		SIR_Members::DFS_ForAllNodes
 * 01/30/01 RD	introduced this header
 */

#include "IntRep/Member.h"
#include "IntRep/Symbol.h"

#include <assert.h>


/*** constants and macros ***********************************************/


	/* (none) */


/*** internal type declarations *****************************************/


	/* (none) */


/*** class implementations **********************************************/


	/******************/
	/*** SIR_Member ***/
	/******************/


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Member::SIR_Member(			/* constructor #1 */
	sir_type	*Type,
	sir_symbol	*Symbol,
	unsigned int	BitFieldSize /* = 0 */,
	unsigned int	Line /* = 0 */,
	sir_fileinfo	*FileInfo /* = NULL */) :
		SIR_Node(Line, FileInfo)
{

assert(Type != NULL);

SIR_Member::Type		= Type;
SIR_Member::Symbol		= Symbol;
SIR_Member::BitFieldSize	= BitFieldSize;

} /* end of SIR_Member::SIR_Member #1 */


SIR_Member::SIR_Member(			/* constructor #3 (duplicator) */
	sir_member	*Original) :
		SIR_Node(Original)
{

SIR_Member::Type		= Original->Type;
SIR_Member::Symbol		= Original->Symbol;
SIR_Member::BitFieldSize	= Original->BitFieldSize;

} /* end of SIR_Member::SIR_Member #3 */


SIR_Member::~SIR_Member(void)		/* destructor */
{

/* nothing to do */

} /* end of SIR_Member::~SIR_Member */


ERROR SIR_Member::DFS_ForAllNodes(	/* iterator for over all nodes */
	sir_node_mptr	MemberFct,	/* (depth first) */
	sir_node_marg	MemberFctArg)
{

if ((SIR_Error = (this->*MemberFct)(MemberFctArg)))	/* process this node */
   { return(SIR_Error);
    } /* fi */

/* there are no nodes below */

return(SIR_ERROR_NO_ERROR);

} /* end of SIR_Member::DFS_ForAllNodes */


	/*******************/
	/*** SIR_Members ***/
	/*******************/


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Members::SIR_Members(	/* constructor #1 */
	sir_member	*FirstEntry /* = NULL */) :
		SIR_List<SIR_Member>(FirstEntry)
{

/* nothing else to do */

} /* end of SIR_Members::SIR_Members #1 */


SIR_Members::SIR_Members(	/* constructor #2 (duplicator) */
	sir_members	*Original)
{
sir_member	*Curr;

Curr = Original->First();
while(Curr)
   { Append(new SIR_Member(Curr));
     Curr = Curr->Succ();
    } /* elihw */

} /* end of SIR_Members::SIR_Members #2 */


SIR_Members::~SIR_Members(void)	/* destructor */
{

/* nothing to do */

} /* end of SIR_Members::~SIR_Members */


ERROR SIR_Members::DFS_ForAllNodes(	/* iterator over all nodes */
	sir_node_mptr	MemberFct,	/* (depth first) */
	sir_node_marg	MemberFctArg)
{
sir_member	*Member,
		*Succ;

/* this is not a node, but there are nodes below */

Member = First();
while(Member)
   { Succ = Member->Succ();
     if ((SIR_Error = Member->DFS_ForAllNodes(MemberFct, MemberFctArg)))
	{ return(SIR_Error);
	 } /* fi */
     Member = Succ;
    } /* elihw */

return(SIR_ERROR_NO_ERROR);

} /* end of SIR_Members::DFS_ForAllNodes */


void SIR_Members::UnAlias(void) /* unalias all type, usertype, symbol links */
{
sir_member	*Member;

Member = First();
while(Member)
   { if (Member->Type->Alias)
	{ Member->Type = Member->Type->Alias;
	 } /* fi */
     if (  (Member->Symbol)
	 &&(Member->Symbol->Alias))
	{ Member->Symbol = Member->Symbol->Alias;
	 } /* fi */
     Member = Member->Succ();
    } /* elihw */

} /* end of SIR_Members::UnAlias */


sir_member *SIR_Members::Find(		/* searches for a specific entry */
	sir_symbol	*Symbol)	/* (returns NULL if not found) */
{
sir_member	*Ptr;

Ptr = First();
while(Ptr)
   { if (Ptr->Symbol == Symbol)
	{ break;	/* found! */
	 } /* fi */
     Ptr = Ptr->Succ();
    } /* elihw */

return(Ptr);

} /* end of SIR_Members::Find */


/*** exported functions *************************************************/


	/* none */


/* EOF Member.cc */
