/************************************************************************/
/* IntRep/Extern.h: SpecC Internal Repr., Interfaces to ext. Modules	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 04/22/98 */
/************************************************************************/

/* last update: 06/15/04 */

/* modifications: (most recent first)
 *
 * 06/15/04 PC  Adjustments for scrc 2.0
 * 05/16/04 PC	buffered and piped classes were included into '_specc' scope
 * 05/14/04 PC	signal class was included into '_specc' scope
 * 10/03/03 RD	added SIR_CXX_FSMD_TMPVAR_PFX
 * 03/14/03 RD	added SIR_SIM_BUF_SLICE_NAME, SIR_SIM_SIG_SLICE_NAME,
 *		SIR_SIM_BUFBUS_SLC_NAME, SIR_SIM_SIGBUS_SLC_NAME
 * 03/05/03 RD	added SIR_SIM_SIG_BUS_NAME, SIR_SIM_BUF_BUS_NAME and
 *		SIR_SIM_NO_SIG_NAME
 * 02/10/03 RD	added SIR_CXX_FSMD_* definitions
 * 01/10/03 RD	added SIR_SIM_AUTO_EVENT_NAME, SIR_CXX_AUTO_EVENT_NAME
 * 12/18/02 RD	added SIR_SIM_*_SIG_PFX
 * 12/12/02 RD	added SIR_SIM_MEMBER_ACCS_FMT
 * 11/26/02 RD	updated simulation library interface for new event lists
 * 09/14/02 RD	added SIR_SPECC_ENV_VAR
 * 08/14/02 RD	bug fix in C++ code generation for naming forked behaviors
 * 07/18/02 RD	added support for code generation for signals and buffers
 * 07/13/02 RD	added SIR_SIM_SIGNAL_NAME, SIR_SIM_BUFFERED_NAME
 * 06/26/02 RD	added 'wait' statement with AND semantics (SIR_SIM_WAITAND_NAME)
 * 04/17/02 RD	bug fix: added SIR_CXX_ANONYMOUS_NAME
 * 03/28/02 RD	added SIR_CXX_ARRAY_INIT_NAME
 * 09/07/01 RD	bug fix: added SIR_SIM_PIPED_ADDSIZE, SIR_SIM_PIPED_ADDALIGN
 * 09/07/01 RD	bug fix: definitions adjusted for modified 'piped' template
 * 05/30/01 RD	removed code not needed for the SCRC
 */


#ifndef INTREP_EXTERN_H
#define INTREP_EXTERN_H


/*** constants and macros ***********************************************/


	/* environment variables */

#define SIR_SPECC_ENV_VAR	"SPECC"


	/* language standard */

/* #define SIR_DELTA_SUPPORT */		/* "delta" is now obsolete! */


	/* simulation library interface */

#define SIR_SIM_HEADER_NAME	"specc.h"
#define SIR_SIM_CLASS_NAME	"_specc"
#define SIR_SIM_SYMBOL_PREFIX	SIR_SIM_CLASS_NAME "::"
#define SIR_SIM_EVENT_NAME	SIR_SIM_SYMBOL_PREFIX "event"
#define SIR_SIM_AUTO_EVENT_NAME	SIR_SIM_SYMBOL_PREFIX "auto_event"
#define SIR_SIM_BEHAVIOR_NAME	SIR_SIM_SYMBOL_PREFIX "behavior"
#define SIR_SIM_CHANNEL_NAME	SIR_SIM_SYMBOL_PREFIX "channel"
#define SIR_SIM_FORK_NAME	SIR_SIM_SYMBOL_PREFIX "fork"
#define SIR_SIM_INIT		SIR_SIM_SYMBOL_PREFIX "start"
#define SIR_SIM_EXIT		SIR_SIM_SYMBOL_PREFIX "end"
#define SIR_SIM_PAR_NAME	SIR_SIM_SYMBOL_PREFIX "par"
#define SIR_SIM_PIPE_NAME	SIR_SIM_SYMBOL_PREFIX "pipe"
//PC 05/16/04
#define SIR_SIM_PIPED_NAME	SIR_SIM_SYMBOL_PREFIX "piped"
#define SIR_SIM_PIPED_IN_ACCESS(s)	".Value[0]"
#define SIR_SIM_PIPED_OUT_ACCESS(s)	".Value[%d]", s
#define SIR_SIM_PIPED_ADDSIZE	4	/* one addl. vtab pointer */
#define SIR_SIM_PIPED_ADDALIGN	SIR_ALIGN_POINTER
#define SIR_SIM_EXCEPTION_NAME	SIR_SIM_SYMBOL_PREFIX "tryTrapInterrupt"
#define SIR_SIM_TRY_BLOCK	SIR_SIM_SYMBOL_PREFIX "try_block"
#define SIR_SIM_EXCEPT_BLOCK	SIR_SIM_SYMBOL_PREFIX "exception_block"
#define SIR_SIM_TRAP_FLAG	"true"
#define SIR_SIM_INTERRUPT_FLAG	"false"
#define SIR_SIM_WAITFOR_NAME	SIR_SIM_SYMBOL_PREFIX "waitfor"
#define SIR_SIM_WAIT_NAME	SIR_SIM_SYMBOL_PREFIX "wait"
#define SIR_SIM_WAITAND_NAME	SIR_SIM_SYMBOL_PREFIX "wait_and"
#define SIR_SIM_NOTIFY_NAME	SIR_SIM_SYMBOL_PREFIX "notify"
#define SIR_SIM_NOTIFYONE_NAME	SIR_SIM_SYMBOL_PREFIX "notifyone"
#define SIR_SIM_CURR_TIME_NAME	SIR_SIM_SYMBOL_PREFIX "getCurrentTime()"
#define SIR_SIM_ABORT		SIR_SIM_SYMBOL_PREFIX "abort"
//PC 05/14/04
#define SIR_SIM_SIGNAL_NAME	SIR_SIM_SYMBOL_PREFIX "signal"
//PC 05/16/04
#define SIR_SIM_BUFFERED_NAME	SIR_SIM_SYMBOL_PREFIX "buffered"
#define SIR_SIM_ANY_SIG_FMT	"event(&%s)"
#define SIR_SIM_ANY_SIG_PFX	"event(&"
#define SIR_SIM_RISING_SIG_FMT	"rising(&%s)"
#define SIR_SIM_RISING_SIG_PFX	"rising(&"
#define SIR_SIM_FALLING_SIG_FMT	"falling(&%s)"
#define SIR_SIM_FALLING_SIG_PFX	"falling(&"
#define SIR_SIM_NO_SIG_NAME	"(" SIR_SIM_SYMBOL_PREFIX "event_ptr*)0"
#define SIR_SIM_MEMBER_ACCS_FMT	".member<%s>(%u)"
#define SIR_SIM_SIG_BUS_NAME	SIR_SIM_SYMBOL_PREFIX "sigbus"
#define SIR_SIM_BUF_BUS_NAME	SIR_SIM_SYMBOL_PREFIX "bufbus"
#define SIR_SIM_BUF_SLICE_NAME	".buf_slice"
#define SIR_SIM_SIG_SLICE_NAME	".sig_slice"
#define SIR_SIM_BUFBUS_SLC_NAME	"bufbus_slice"
#define SIR_SIM_SIGBUS_SLC_NAME	"sigbus_slice"


	/* longlong library interface */

#define SIR_LLONG_HEADER_NAME	"longlong.h"
#ifndef HAVE_LLONG
#define SIR_LLONG_CLASS_NAME	"_longlong"
#define SIR_LLONG_SHADOW_NAME	"_longlong_"
#define SIR_LLONG_SIGNED_FLAG	"false"
#define SIR_LLONG_UNSIGNED_FLAG	"true"
#define SIR_LLONG2_BOOL_NAME	"test"
#define SIR_LLONG2_INT_NAME	"toInt"
#define SIR_LLONG2_UINT_NAME	"toUInt"
#define SIR_LLONG2_LONG_NAME	"toLong"
#define SIR_LLONG2_ULONG_NAME	"toULong"
#define SIR_LLONG2_DOUBLE_NAME	"toDouble"
#define SIR_LLONG2_LDOUBLE_NAME	"toLDouble"
#endif /* !HAVE_LLONG */

#ifdef HAVE_LLONG
#define SIR_LLONG2B(v)		v
#define SIR_LLONG2I(v)		v
#define SIR_LLONG2UI(v)		v
#define SIR_LLONG2L(v)		v
#define SIR_LLONG2UL(v)		v
#define SIR_LLONG2D(v)		v
#define SIR_LLONG2LD(v)		v
#else /* !HAVE_LLONG */
#define SIR_LLONG2B(v)		(v.test())
#define SIR_LLONG2I(v)		(v.toInt())
#define SIR_LLONG2UI(v)		(v.toUInt())
#define SIR_LLONG2L(v)		(v.toLong())
#define SIR_LLONG2UL(v)		(v.toULong())
#define SIR_LLONG2D(v)		(v.toDouble())
#define SIR_LLONG2LD(v)		(v.toLDouble())
#endif /* HAVE_LLONG */


	/* bitvector library interface */

#define SIR_BIT_HEADER_NAME	"bit.h"
#define SIR_BIT_CLASS_NAME	"bit"
#define SIR_BIT_SHADOW_NAME	"_bit_"
#define SIR_BIT_BASE_CLASS_NAME	"_bit"
#define SIR_BIT_BUS_CLASS_NAME	"_bitbus"
#define SIR_BIT_BUS_SLICE_NAME	"bus_slice"
#define SIR_BIT_BUS_CONCAT_NAME	"concat"
#define SIR_BIT_SIGNED		false
#define SIR_BIT_UNSIGNED	true
#define SIR_BIT_SIGNED_FLAG	"false"
#define SIR_BIT_UNSIGNED_FLAG	"true"
#define SIR_BIT_SYMBOL_PREFIX	SIR_BIT_BASE_CLASS_NAME "::"
#define SIR_BIT_CONCAT_NAME	SIR_BIT_SYMBOL_PREFIX "concat"
#define SIR_BIT_SLICE_NAME	""
#define SIR_BIT_LENGTH_NAME	"_BITLEN"
#define SIR_BIT_2_BOOL_NAME	"test"
#define SIR_BIT_2_INT_NAME	"toInt"
#define SIR_BIT_2_UINT_NAME	"toUInt"
#define SIR_BIT_2_LONG_NAME	"toLong"
#define SIR_BIT_2_ULONG_NAME	"toULong"
#define SIR_BIT_2_LLONG_NAME	"toLLong"
#define SIR_BIT_2_ULLONG_NAME	"toULLong"
#define SIR_BIT_2_DOUBLE_NAME	"toDouble"
#define SIR_BIT_2_LDOUBLE_NAME	"toLDouble"
#define SIR_BIT_DIRECTLY_MAPPABLE(p_l, p_r, p_s, b_l, b_r, b_s)	\
	(  ((p_s) == (b_s))					\
	 &&((ABS((p_l)-(p_r))+1) == (ABS((b_l)-(b_r))+1)) )
#define SIR_BIT_VEC_ADD_SIZE	4	/* one addl. vtab pointer */
#define SIR_BIT_VEC_ADD_ALIGN	SIR_ALIGN_POINTER
#define SIR_BIT_BUS_ADD_SIZE	8	/* one addl. vtab and another pointer */
#define SIR_BIT_BUS_ADD_ALIGN	SIR_ALIGN_POINTER


	/* translator to C++ interface */

#define SIR_CXX_NEW_NAME_PREFIX	"_scc_"
#define SIR_CXX_MAIN_INST_NAME	SIR_CXX_NEW_NAME_PREFIX "main"
#define SIR_CXX_MAIN_ARG_NAME	SIR_CXX_NEW_NAME_PREFIX "main_arg_%d"
#define SIR_CXX_MAIN_RET_NAME	SIR_CXX_NEW_NAME_PREFIX "main_return"
#define SIR_CXX_STATE_PREFIX	SIR_CXX_NEW_NAME_PREFIX "state_"
#define SIR_CXX_STATE_VARIABLE	SIR_CXX_NEW_NAME_PREFIX "next_state"
#define SIR_CXX_FORK_VARIABLE	SIR_CXX_NEW_NAME_PREFIX "fork_%d"
#define SIR_CXX_TRY_VARIABLE	SIR_CXX_NEW_NAME_PREFIX "try_"
#define SIR_CXX_EXCEPT_VARIABLE	SIR_CXX_NEW_NAME_PREFIX "exception_%d"
#define SIR_CXX_SLICED_BUS_NAME	SIR_CXX_NEW_NAME_PREFIX "bus_%d"
#define SIR_CXX_OPEN_PORT_NAME	SIR_CXX_NEW_NAME_PREFIX "open_port_%d"
#define SIR_CXX_CONST_PORT_NAME	SIR_CXX_NEW_NAME_PREFIX "const_port_%d"
#define SIR_CXX_DUMMY_PORT_NAME	SIR_CXX_NEW_NAME_PREFIX "port_%d"
#define SIR_CXX_ANONYMOUS_NAME	SIR_CXX_NEW_NAME_PREFIX "anonymous_%d"
#define SIR_CXX_RESERVED_UNIT	"char"
#define SIR_CXX_RESERVED_NAME	SIR_CXX_NEW_NAME_PREFIX "reserved"
#ifdef HAVE_LLONG
#define SIR_CXX_TIME_TYPE	"unsigned long long"
#else /* !HAVE_LLONG */
#define SIR_CXX_TIME_TYPE	SIR_LLONG_CLASS_NAME	\
				"<" SIR_LLONG_UNSIGNED_FLAG ">"
#endif /* HAVE_LLONG */
#define SIR_CXX_TIMESTAMP_PREFX	SIR_CXX_NEW_NAME_PREFIX "time_stamp_"
#define SIR_CXX_RANGE_NAME	SIR_CXX_NEW_NAME_PREFIX "range_check"
#define SIR_CXX_FIRST_NAME	SIR_CXX_NEW_NAME_PREFIX "first"
#define SIR_CXX_LAST_NAME	SIR_CXX_NEW_NAME_PREFIX "last"
#define SIR_CXX_INDEX_NAME	SIR_CXX_NEW_NAME_PREFIX "index_"
#define SIR_CXX_ARRAY_INIT_NAME SIR_CXX_NEW_NAME_PREFIX "init_"
#define SIR_CXX_AUTO_EVENT_NAME SIR_CXX_NEW_NAME_PREFIX "clock_"
#define SIR_CXX_FSMD_CLOCK_NAME SIR_CXX_NEW_NAME_PREFIX "clock"
#define SIR_CXX_FSMD_STATE_TYPE	SIR_CXX_NEW_NAME_PREFIX "state"
#define SIR_CXX_FSMD_STATE_PFX	SIR_CXX_NEW_NAME_PREFIX "state_"
#define SIR_CXX_FSMD_STATE_REG	SIR_CXX_NEW_NAME_PREFIX "state_register"
#define SIR_CXX_FSMD_BREAKSTATE	SIR_CXX_FSMD_STATE_PFX "break"
#define SIR_CXX_FSMD_TMPVAR_PFX	SIR_CXX_NEW_NAME_PREFIX "tmp_0"


#endif /* INTREP_EXTERN_H */

/* EOF IntRep/Extern.h */
