// PortAccess.sc: example for legal (and illegal) accesses to ports
//
// last change: 01/11/02, RD


behavior IntAdder(out int a, in int b, inout int c)
{
	int t;

	void main(void)
	{
		t = b;		// OK: read access to input port
		t += c;		// OK: read access to inout port
		a = t;		// OK: write access to output port
		c = t;		// OK: write access to inout port
		c++;		// OK: read-write access to inout port

	//	t = a;		// illegal: read access to output port
	//	b = t;		// illegal: write access to input port
	//	a++;		// illegal: read-write access to output port
	//	b++;		// illegal: read-write access to input port
	}
};

behavior BitAdder(out bit[8] a, in bit[8] b, inout bit[8] c)
{
	int t;

	void main(void)
	{
		t = b;		// OK: read access to input port
		t += c;		// OK: read access to inout port
		a = t;		// OK: write access to output port
		c = t;		// OK: write access to inout port
		c++;		// OK: read-write access to inout port

	//	t = a;		// illegal: read access to output port
	//	b = t;		// illegal: write access to input port
	//	a++;		// illegal: read-write access to output port
	//	b++;		// illegal: read-write access to input port

	//	t = a[3:0];	// illegal: sliced read access to output port
				// (bug fix 01/09/02, RD)
	//	b[3:0] = t;	// illegal: sliced write access to input port
				// (bug fix 01/09/02, RD)
	//	t = a[4];	// illegal: bit read access to output port
				// (bug fix 01/09/02, RD)
	//	b[4] = t;	// illegal: bit write access to input port
				// (bug fix 01/09/02, RD)
	}
};

behavior ArrayUnit(out int A[10], in int B[10])
{
	int t;
	int T[10];

	void main(void)
	{
		T = B;		// OK: array read access to input array
		A = T;		// OK: array write access to output array
		t = B[1];	// OK: element read access to input array
		A[2] = t;	// OK: element write access to output array
		A = B;		// OK: copy whole array from in to out

	//	T = A;		// illegal: array read access to output array
	//	B = T;		// illegal: array write access to input array
	//	t = A[1];	// illegal: element read access to output array
				// (bug fix 01/09/02, RD)
	//	B[2] = t;	// illegal: element write access to input array
				// (bug fix 01/09/02, RD)
	//	A[1]++;		// illegal: element r-w access to output array
				// (bug fix 01/09/02, RD)
	//	B[2]++;		// illegal: element r-w access to input array
				// (bug fix 01/09/02, RD)
	//	B = A;		// illegal: copy whole array from out to in
	}
};

behavior PointerUnit(out int *a, in int *b, inout int *c)
{
	int *p, t;

	void main(void)
	{
		p = b;		// OK: read access to input port
		p += 2;		// OK: read access to inout port
		a = p;		// OK: write access to output port
		c = p;		// OK: write access to inout port
		c++;		// OK: read-write access to inout port

	//	p = a;		// illegal: read access to output port
	//	b = p;		// illegal: write access to input port
	//	a++;		// illegal: read-write access to output port
	//	b++;		// illegal: read-write access to input port

		t = *b;		// OK: read access to input pointer
		t = *c;		// OK: read access to inout pointer
	//	t = *a;		// illegal: read access to output pointer

		*b = t;		// OK: read access (!) to input pointer
		*c = t;		// OK: read access (!) to inout pointer
	//	*a = t;		// illegal: read access (!) to output pointer

		a = &t;		// OK: write access to output pointer
		c = &t;		// OK: write access to inout pointer
	//	b = &t;		// illegal: write access to input pointer
	}
};

struct S { int i; float f; };

behavior StructureUnit(out struct S A, in struct S B)
{
	int t;
	struct S T;

	void main(void)
	{
		T = B;		// OK: full read access to input structure
		A = T;		// OK: full write access to output structure
		t = B.i;	// OK: member read access to input structure
		A.i = t;	// OK: member write access to output structure
		A = B;		// OK: copy whole structure from in to out

	//	T = A;		// illegal: full read access to output structure
	//	B = T;		// illegal: full write access to input structure
	//	t = A.i;	// illegal: member read access to output struct
				// (bug fix 01/09/02, RD)
	//	B.i = t;	// illegal: member write access to input struct
				// (bug fix 01/09/02, RD)
	//	A.i++;		// illegal: member r-w access to output struct
				// (bug fix 01/09/02, RD)
	//	B.i++;		// illegal: member r-w access to input struct
				// (bug fix 01/09/02, RD)
	//	B = A;		// illegal: copy whole structure from out to in
	}
};

behavior Cheating(in int a, out int b)	// don't try this at home!  ;-)
{
	int t, *p;

	void main(void)
	{
		t = (int)b;	// cast away the port direction
		p = &a; *p = t;	// use pointers
	}
};


// actual bug report on 05/30/01 by AG
// (bug fix 01/09/02, RD)

behavior Tst(in int array[40])
{
  void main(void)
  {
//    array[14] = 4;	// illegal: write access to input port of array type
  }
};


// EOF
